"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverTopNav = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _customizations = require("../../../../customizations");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _use_inspector = require("../../hooks/use_inspector");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _get_top_nav_badges = require("./get_top_nav_badges");
var _use_top_nav_links = require("./use_top_nav_links");
var _redux = require("../../state_management/redux");
var _use_has_share_integration = require("../../hooks/use_has_share_integration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useDiscoverTopNav = ({
  stateContainer
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const topNavCustomization = (0, _customizations.useDiscoverCustomization)('top_nav');
  const hasSavedSearchChanges = (0, _useObservable.default)(stateContainer.savedSearchState.getHasChanged$());
  const hasUnsavedChanges = Boolean(hasSavedSearchChanges && stateContainer.savedSearchState.getId());
  const topNavBadges = (0, _react.useMemo)(() => (0, _get_top_nav_badges.getTopNavBadges)({
    stateContainer,
    services,
    hasUnsavedChanges,
    topNavCustomization
  }), [stateContainer, services, hasUnsavedChanges, topNavCustomization]);
  const savedSearchId = (0, _discover_state_provider.useSavedSearch)().id;
  const savedSearchHasChanged = (0, _discover_state_provider.useSavedSearchHasChanged)();
  const shouldShowESQLToDataViewTransitionModal = !savedSearchId || savedSearchHasChanged;
  const dataView = (0, _redux.useRuntimeState)(stateContainer.runtimeStateManager.currentDataView$);
  const adHocDataViews = (0, _redux.useRuntimeState)(stateContainer.runtimeStateManager.adHocDataViews$);
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const onOpenInspector = (0, _use_inspector.useInspector)({
    inspector: services.inspector,
    stateContainer
  });
  const hasShareIntegration = (0, _use_has_share_integration.useHasShareIntegration)(services);
  const topNavMenu = (0, _use_top_nav_links.useTopNavLinks)({
    dataView,
    services,
    state: stateContainer,
    onOpenInspector,
    isEsqlMode,
    adHocDataViews,
    topNavCustomization,
    shouldShowESQLToDataViewTransitionModal,
    hasShareIntegration
  });
  return {
    topNavMenu,
    topNavBadges
  };
};
exports.useDiscoverTopNav = useDiscoverTopNav;