"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverRoutes = exports.DiscoverRouter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _context = require("./context");
var _doc = require("./doc");
var _main = require("./main");
var _not_found = require("./not_found");
var _view_alert = require("./view_alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DiscoverRouter = ({
  customizationContext$,
  services,
  history,
  ...routeProps
}) => {
  const customizationContext = (0, _useObservable.default)(customizationContext$);

  // The Discover state is not reactive, so we must avoid initialization before
  // the first value is emitted
  if (customizationContext == null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    "data-test-subj": "discover-react-router"
  }, /*#__PURE__*/_react.default.createElement(DiscoverRoutes, (0, _extends2.default)({
    customizationContext: customizationContext,
    services: services,
    history: history
  }, routeProps)))));
};
exports.DiscoverRouter = DiscoverRouter;
// this exists as a separate component to allow the tests to gather the routes
const DiscoverRoutes = ({
  customizationContext,
  services,
  history,
  ...routeProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/context/:dataViewId/:id"
  }, /*#__PURE__*/_react.default.createElement(_context.ContextAppRoute, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/doc/:dataView/:index/:type",
    render: props => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: `/doc/${props.match.params.dataView}/${props.match.params.index}`
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/doc/:dataViewId/:index"
  }, /*#__PURE__*/_react.default.createElement(_doc.SingleDocRoute, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/viewAlert/:id"
  }, /*#__PURE__*/_react.default.createElement(_view_alert.ViewAlertRoute, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/view/:id"
  }, /*#__PURE__*/_react.default.createElement(_main.DiscoverMainRoute, (0, _extends2.default)({
    customizationContext: customizationContext
  }, routeProps))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_main.DiscoverMainRoute, (0, _extends2.default)({
    customizationContext: customizationContext
  }, routeProps))), /*#__PURE__*/_react.default.createElement(_not_found.NotFoundRoute, null));
};
exports.DiscoverRoutes = DiscoverRoutes;