"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQuickTimeRanges = useQuickTimeRanges;
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useQuickTimeRanges() {
  const timePickerQuickRanges = (0, _public.useUiSetting)(_common.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  return timePickerQuickRanges.map(({
    from,
    to,
    display
  }) => ({
    start: from,
    end: to,
    label: display
  }));
}