"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorMessageContent = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorMessageContent = ({
  fieldName,
  error
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    heading: "p",
    color: "danger",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.index.fieldStatisticsErrorMessage",
    defaultMessage: "Error getting statistics for field ''{fieldName}'' because {reason}",
    values: {
      fieldName,
      reason: error.message
    }
  }));
};
exports.ErrorMessageContent = ErrorMessageContent;