"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSearchSourceOut = transformSearchSourceOut;
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformSearchSourceOut(kibanaSavedObjectMeta) {
  const {
    searchSourceJSON
  } = kibanaSavedObjectMeta;
  if (!searchSourceJSON) {
    return {};
  }
  // Dashboards do not yet support ES|QL (AggregateQuery) in the search source
  return {
    searchSource: (0, _common.parseSearchSourceJSON)(searchSourceJSON)
  };
}