"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = exports.dashboardSavedObjectSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _v = require("../../dashboard_saved_object/schema/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dashboardSavedObjectSchema = exports.dashboardSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(_v.dashboardAttributesSchema);
const searchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  onlyTitle: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'forbid'
}));
const createOptionsSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.id),
  overwrite: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.overwrite),
  references: _configSchema.schema.maybe(_contentManagementUtils.createOptionsSchemas.references)
});
const dashboardUpdateOptionsSchema = _configSchema.schema.object({
  references: _configSchema.schema.maybe(_contentManagementUtils.updateOptionsSchema.references),
  mergeAttributes: _configSchema.schema.maybe(_contentManagementUtils.updateOptionsSchema.mergeAttributes)
});

/**
 * Content management service definition v1.
 * Dashboard attributes in content management version v1 are tightly coupled with the v1 model version saved object schema.
 */
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: (0, _contentManagementUtils.objectTypeToGetResultSchema)(dashboardSavedObjectSchema)
      }
    }
  },
  create: {
    in: {
      options: {
        schema: createOptionsSchema
      },
      data: {
        schema: _v.dashboardAttributesSchema
      }
    },
    out: {
      result: {
        schema: (0, _contentManagementUtils.createResultSchema)(dashboardSavedObjectSchema)
      }
    }
  },
  update: {
    in: {
      options: {
        schema: dashboardUpdateOptionsSchema
      },
      data: {
        schema: _v.dashboardAttributesSchema
      }
    }
  },
  search: {
    in: {
      options: {
        schema: searchOptionsSchema
      }
    }
  }
};