"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractSearchState = extractSearchState;
var _load_dashboard_state = require("../../../services/dashboard_content_management_service/lib/load_dashboard_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function extractSearchState(state) {
  const searchState = {};
  if (Array.isArray(state.filters)) {
    searchState.filters = state.filters;
  }
  if (state.query && typeof state.query === 'object') {
    searchState.query = (0, _load_dashboard_state.migrateLegacyQuery)(state.query);
  }
  if (state.refreshInterval && typeof state.refreshInterval === 'object') {
    searchState.refreshInterval = state.refreshInterval;
  }
  if (state.timeRange && typeof state.timeRange === 'object') {
    searchState.timeRange = state.timeRange;
  }
  return searchState;
}