"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddESQLControlButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _esqlTypes = require("@kbn/esql-types");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _use_dashboard_api = require("../../../dashboard_api/use_dashboard_api");
var _kibana_services = require("../../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const AddESQLControlButton = ({
  closePopover,
  controlGroupApi,
  ...rest
}) => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const onSaveControl = controlState => {
    controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.addNewPanel({
      panelType: 'esqlControl',
      serializedState: {
        rawState: {
          ...controlState
        }
      }
    });
    dashboardApi.scrollToTop();
    closePopover();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({}, rest, {
    icon: "plusInCircle",
    "data-test-subj": "esql-control-create-button",
    disabled: !controlGroupApi,
    "aria-label": (0, _dashboard_app_strings.getAddESQLControlButtonTitle)(),
    onClick: async () => {
      try {
        const variablesInParent = (0, _esqlTypes.apiPublishesESQLVariables)(dashboardApi) ? dashboardApi.esqlVariables$.value : [];
        await _kibana_services.uiActionsService.getTrigger('ESQL_CONTROL_TRIGGER').exec({
          queryString: '',
          variableType: _esqlTypes.ESQLVariableType.VALUES,
          controlType: _esqlTypes.EsqlControlType.VALUES_FROM_QUERY,
          esqlVariables: variablesInParent,
          onSaveControl,
          onCancelControl: closePopover
        });
      } catch (e) {
        // eslint-disable-next-line no-console
        console.error('Error getting ESQL control trigger', e);
      }
      closePopover();
    }
  }), (0, _dashboard_app_strings.getAddESQLControlButtonTitle)());
};
exports.AddESQLControlButton = AddESQLControlButton;