"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Group = Group;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function Group({
  group
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    id: `${group.id}-group`,
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, group.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    "aria-labelledby": `${group.id}-group`,
    size: "s",
    gutterSize: "none",
    maxWidth: false,
    flush: true
  }, group.items.map(item => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
      key: item.id,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "right",
        content: item.description
      }, !item.isDeprecated ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, item.name) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        wrap: true,
        responsive: false,
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, item.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.editorMenu.deprecatedTag",
        defaultMessage: "Deprecated"
      }))))),
      onClick: item.onClick,
      iconType: item.icon,
      "data-test-subj": item['data-test-subj'],
      isDisabled: item.isDisabled
    });
  })));
}