"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardPageTitle = exports.getDashboardBreadcrumb = exports.getCreateVisualizationButtonTitle = exports.getControlButtonTitle = exports.getAddTimeSliderControlButtonTitle = exports.getAddESQLControlButtonTitle = exports.getAddControlButtonTitle = exports.dashboardReadonlyBadge = exports.dashboardManagedBadge = void 0;
exports.getDashboardTitle = getDashboardTitle;
exports.unsavedChangesBadgeStrings = exports.topNavStrings = exports.shareModalStrings = exports.getQuickCreateButtonGroupLegend = exports.getPanelTooOldErrorString = exports.getPanelAddedSuccessString = exports.getOnlyOneTimeSliderControlMsg = exports.getNewDashboardTitle = exports.getEditControlGroupButtonTitle = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDashboardPageTitle = () => _i18n.i18n.translate('dashboard.dashboardPageTitle', {
  defaultMessage: 'Dashboards'
});
exports.getDashboardPageTitle = getDashboardPageTitle;
const dashboardReadonlyBadge = exports.dashboardReadonlyBadge = {
  getText: () => _i18n.i18n.translate('dashboard.badge.readOnly.text', {
    defaultMessage: 'Read only'
  }),
  getTooltip: () => _i18n.i18n.translate('dashboard.badge.readOnly.tooltip', {
    defaultMessage: 'Unable to save dashboards'
  })
};
const dashboardManagedBadge = exports.dashboardManagedBadge = {
  getDuplicateButtonAriaLabel: () => _i18n.i18n.translate('dashboard.managedContentPopoverFooterText', {
    defaultMessage: 'Click here to duplicate this dashboard'
  }),
  getBadgeAriaLabel: () => _i18n.i18n.translate('dashboard.managedContentBadge.ariaLabel', {
    defaultMessage: 'Elastic manages this dashboard. Duplicate it to make changes.'
  })
};

/**
 * @param title {string} the current title of the dashboard
 * @param viewMode {DashboardViewMode} the current mode. If in editing state, prepends 'Editing ' to the title.
 * @returns {string} A title to display to the user based on the above parameters.
 */
function getDashboardTitle(title, viewMode, isNew) {
  const isEditMode = viewMode === 'edit';
  const dashboardTitle = isNew || !Boolean(title) ? getNewDashboardTitle() : title;
  return isEditMode ? _i18n.i18n.translate('dashboard.strings.dashboardEditTitle', {
    defaultMessage: 'Editing {title}',
    values: {
      title: dashboardTitle
    }
  }) : dashboardTitle;
}
const unsavedChangesBadgeStrings = exports.unsavedChangesBadgeStrings = {
  getUnsavedChangedBadgeText: () => _i18n.i18n.translate('dashboard.unsavedChangesBadge', {
    defaultMessage: 'Unsaved changes'
  }),
  getUnsavedChangedBadgeToolTipContent: () => _i18n.i18n.translate('dashboard.unsavedChangesBadgeToolTipContent', {
    defaultMessage: ' You have unsaved changes in this dashboard. To remove this label, save the dashboard.'
  })
};
const getCreateVisualizationButtonTitle = () => _i18n.i18n.translate('dashboard.solutionToolbar.addPanelButtonLabel', {
  defaultMessage: 'Create visualization'
});
exports.getCreateVisualizationButtonTitle = getCreateVisualizationButtonTitle;
const getQuickCreateButtonGroupLegend = () => _i18n.i18n.translate('dashboard.solutionToolbar.quickCreateButtonGroupLegend', {
  defaultMessage: 'Shortcuts to popular visualization types'
});
exports.getQuickCreateButtonGroupLegend = getQuickCreateButtonGroupLegend;
const getNewDashboardTitle = () => _i18n.i18n.translate('dashboard.savedDashboard.newDashboardTitle', {
  defaultMessage: 'New Dashboard'
});
exports.getNewDashboardTitle = getNewDashboardTitle;
const getPanelAddedSuccessString = savedObjectName => savedObjectName ? _i18n.i18n.translate('dashboard.addPanel.newEmbeddableAddedSuccessMessageTitle', {
  defaultMessage: '{savedObjectName} was added',
  values: {
    savedObjectName
  }
}) : _i18n.i18n.translate('dashboard.addPanel.newEmbeddableWithNoTitleAddedSuccessMessageTitle', {
  defaultMessage: 'A panel was added'
});
exports.getPanelAddedSuccessString = getPanelAddedSuccessString;
const getPanelTooOldErrorString = () => _i18n.i18n.translate('dashboard.loadURLError.PanelTooOld', {
  defaultMessage: 'Cannot load panels from a URL created in a version older than 7.3'
});

/*
  Share Modal
*/
exports.getPanelTooOldErrorString = getPanelTooOldErrorString;
const shareModalStrings = exports.shareModalStrings = {
  getTopMenuCheckbox: () => _i18n.i18n.translate('dashboard.embedUrlParamExtension.topMenu', {
    defaultMessage: 'Top menu'
  }),
  getQueryCheckbox: () => _i18n.i18n.translate('dashboard.embedUrlParamExtension.query', {
    defaultMessage: 'Query'
  }),
  getTimeFilterCheckbox: () => _i18n.i18n.translate('dashboard.embedUrlParamExtension.timeFilter', {
    defaultMessage: 'Time filter'
  }),
  getFilterBarCheckbox: () => _i18n.i18n.translate('dashboard.embedUrlParamExtension.filterBar', {
    defaultMessage: 'Filter bar'
  }),
  getCheckboxLegend: () => _i18n.i18n.translate('dashboard.embedUrlParamExtension.include', {
    defaultMessage: 'Include'
  }),
  getSnapshotShareWarning: () => _i18n.i18n.translate('dashboard.snapshotShare.longUrlWarning', {
    defaultMessage: 'One or more panels on this dashboard have changed. Before you generate a snapshot, save the dashboard.'
  }),
  getDraftSharePanelChangesWarning: () => _i18n.i18n.translate('dashboard.snapshotShare.panelChangesWarning', {
    defaultMessage: 'You are about to share a dashboard with unsaved changes, and the link may not work properly. Save the dashboard first to create a permanent link.'
  }),
  getEmbedSharePanelChangesWarning: () => _i18n.i18n.translate('dashboard.embedShare.draftWarning', {
    defaultMessage: 'You are about to create an embedded dashboard with unsaved changes, and the embed code may not work properly. Save the dashboard first to create a permanent embedded dashboard.'
  }),
  getDraftShareWarning: shareType => _i18n.i18n.translate('dashboard.snapshotShare.draftWarning', {
    defaultMessage: 'This dashboard has unsaved changes. Consider saving your dashboard before generating the {shareType}.',
    values: {
      shareType: shareType === 'embed' ? 'embed code' : 'link'
    }
  })
};

/*
  Dashboard Top Nav
*/
const getDashboardBreadcrumb = () => _i18n.i18n.translate('dashboard.dashboardAppBreadcrumbsTitle', {
  defaultMessage: 'Dashboards'
});
exports.getDashboardBreadcrumb = getDashboardBreadcrumb;
const topNavStrings = exports.topNavStrings = {
  fullScreen: {
    label: _i18n.i18n.translate('dashboard.topNave.fullScreenButtonAriaLabel', {
      defaultMessage: 'full screen'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.fullScreenConfigDescription', {
      defaultMessage: 'Full Screen Mode'
    })
  },
  labs: {
    label: _i18n.i18n.translate('dashboard.topNav.labsButtonAriaLabel', {
      defaultMessage: 'labs'
    }),
    description: _i18n.i18n.translate('dashboard.topNav.labsConfigDescription', {
      defaultMessage: 'Labs'
    })
  },
  edit: {
    label: _i18n.i18n.translate('dashboard.topNave.editButtonAriaLabel', {
      defaultMessage: 'edit'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.editConfigDescription', {
      defaultMessage: 'Switch to edit mode'
    })
  },
  quickSave: {
    label: _i18n.i18n.translate('dashboard.topNave.saveButtonAriaLabel', {
      defaultMessage: 'save'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.saveConfigDescription', {
      defaultMessage: 'Quick save your dashboard without any prompts'
    })
  },
  editModeInteractiveSave: {
    label: _i18n.i18n.translate('dashboard.topNave.editModeInteractiveSaveButtonAriaLabel', {
      defaultMessage: 'save as'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.editModeInteractiveSaveConfigDescription', {
      defaultMessage: 'Save as a new dashboard'
    })
  },
  resetChanges: {
    label: _i18n.i18n.translate('dashboard.topNave.resetChangesButtonAriaLabel', {
      defaultMessage: 'Reset'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.resetChangesConfigDescription', {
      defaultMessage: 'Reset changes to dashboard'
    })
  },
  switchToViewMode: {
    label: _i18n.i18n.translate('dashboard.topNave.cancelButtonAriaLabel', {
      defaultMessage: 'Switch to view mode'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.viewConfigDescription', {
      defaultMessage: 'Switch to view-only mode'
    })
  },
  export: {
    label: _i18n.i18n.translate('dashboard.topNave.exportButtonAriaLabel', {
      defaultMessage: 'Export'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.exportConfigDescription', {
      defaultMessage: 'Export dashboard'
    })
  },
  share: {
    label: _i18n.i18n.translate('dashboard.topNave.shareButtonAriaLabel', {
      defaultMessage: 'share'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.shareConfigDescription', {
      defaultMessage: 'Share Dashboard'
    })
  },
  settings: {
    label: _i18n.i18n.translate('dashboard.topNave.settingsButtonAriaLabel', {
      defaultMessage: 'settings'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.settingsConfigDescription', {
      defaultMessage: 'Open dashboard settings'
    })
  },
  viewModeInteractiveSave: {
    label: _i18n.i18n.translate('dashboard.topNave.viewModeInteractiveSaveButtonAriaLabel', {
      defaultMessage: 'duplicate'
    }),
    description: _i18n.i18n.translate('dashboard.topNave.viewModeInteractiveSaveConfigDescription', {
      defaultMessage: 'Create a copy of your dashboard'
    })
  }
};
const getControlButtonTitle = () => _i18n.i18n.translate('dashboard.editingToolbar.controlsButtonTitle', {
  defaultMessage: 'Controls'
});
exports.getControlButtonTitle = getControlButtonTitle;
const getAddControlButtonTitle = () => _i18n.i18n.translate('dashboard.editingToolbar.addControlButtonTitle', {
  defaultMessage: 'Add control'
});
exports.getAddControlButtonTitle = getAddControlButtonTitle;
const getAddESQLControlButtonTitle = () => _i18n.i18n.translate('dashboard.editingToolbar.addESQLControlButtonTitle', {
  defaultMessage: 'Add ES|QL control'
});
exports.getAddESQLControlButtonTitle = getAddESQLControlButtonTitle;
const getEditControlGroupButtonTitle = () => _i18n.i18n.translate('dashboard.editingToolbar.editControlGroupButtonTitle', {
  defaultMessage: 'Settings'
});
exports.getEditControlGroupButtonTitle = getEditControlGroupButtonTitle;
const getOnlyOneTimeSliderControlMsg = () => _i18n.i18n.translate('dashboard.editingToolbar.onlyOneTimeSliderControlMsg', {
  defaultMessage: 'Control group already contains time slider control.'
});
exports.getOnlyOneTimeSliderControlMsg = getOnlyOneTimeSliderControlMsg;
const getAddTimeSliderControlButtonTitle = () => _i18n.i18n.translate('dashboard.editingToolbar.addTimeSliderControlButtonTitle', {
  defaultMessage: 'Add time slider control'
});
exports.getAddTimeSliderControlButtonTitle = getAddTimeSliderControlButtonTitle;