"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDrilldownTemplatesFromSiblings = exports.DRILLDOWN_MAX_WIDTH = exports.DRILLDOWN_ACTION_GROUP = void 0;
exports.ensureNestedTriggers = ensureNestedTriggers;
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public3 = require("@kbn/embeddable-enhanced-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * We know that VALUE_CLICK_TRIGGER and SELECT_RANGE_TRIGGER are also triggering APPLY_FILTER_TRIGGER.
 * This function appends APPLY_FILTER_TRIGGER to the list of triggers if either VALUE_CLICK_TRIGGER
 * or SELECT_RANGE_TRIGGER was executed.
 *
 * TODO: this probably should be part of uiActions infrastructure,
 * but dynamic implementation of nested trigger doesn't allow to statically express such relations
 *
 * @param triggers
 */
function ensureNestedTriggers(triggers) {
  if (!triggers.includes(_public.APPLY_FILTER_TRIGGER) && (triggers.includes(_public2.VALUE_CLICK_TRIGGER) || triggers.includes(_public2.SELECT_RANGE_TRIGGER))) {
    return [...triggers, _public.APPLY_FILTER_TRIGGER];
  }
  return triggers;
}

/**
 * Given a dashboard panel embeddable, it will find the parent (dashboard
 * container embeddable), then iterate through all the dashboard panels and
 * generate DrilldownTemplate for each existing drilldown.
 */
const createDrilldownTemplatesFromSiblings = embeddable => {
  const parentApi = embeddable.parentApi;
  if (!(0, _presentationContainers.apiIsPresentationContainer)(parentApi)) return [];
  const templates = [];
  for (const childId of Object.keys(parentApi.children$.value)) {
    const child = parentApi.children$.value[childId];
    if (childId === embeddable.uuid) continue;
    if (!(0, _public3.apiHasDynamicActions)(child)) continue;
    const events = child.enhancements.dynamicActions.state.get().events;
    for (const event of events) {
      var _ref, _getTitle;
      const template = {
        id: event.eventId,
        name: event.action.name,
        icon: 'dashboardApp',
        description: (_ref = (_getTitle = (0, _presentationPublishing.getTitle)(child)) !== null && _getTitle !== void 0 ? _getTitle : child.uuid) !== null && _ref !== void 0 ? _ref : '',
        config: event.action.config,
        factoryId: event.action.factoryId,
        triggers: event.triggers
      };
      templates.push(template);
    }
  }
  return templates;
};
exports.createDrilldownTemplatesFromSiblings = createDrilldownTemplatesFromSiblings;
const DRILLDOWN_MAX_WIDTH = exports.DRILLDOWN_MAX_WIDTH = 500;
const DRILLDOWN_ACTION_GROUP = exports.DRILLDOWN_ACTION_GROUP = {
  id: 'drilldown',
  order: 3
};