"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setApiError = exports.sendApiRequest = exports.clearApiError = exports.apiRequestStart = exports.apiRequestEnd = void 0;
var t = _interopRequireWildcard(require("../action_types"));
var _constants = require("../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apiRequestStart = ({
  label,
  scope,
  status = _constants.API_STATUS.LOADING
}) => ({
  type: t.API_REQUEST_START,
  payload: {
    label,
    scope,
    status
  }
});
exports.apiRequestStart = apiRequestStart;
const apiRequestEnd = ({
  label,
  scope
}) => ({
  type: t.API_REQUEST_END,
  payload: {
    label,
    scope
  }
});
exports.apiRequestEnd = apiRequestEnd;
const setApiError = ({
  error,
  scope
}) => ({
  type: t.API_ERROR_SET,
  payload: {
    error,
    scope
  }
});
exports.setApiError = setApiError;
const clearApiError = scope => ({
  type: t.API_ERROR_SET,
  payload: {
    error: null,
    scope
  }
});
exports.clearApiError = clearApiError;
const sendApiRequest = ({
  label,
  scope,
  status,
  handler,
  onSuccess = () => undefined,
  onError = () => undefined
}) => async (dispatch, getState) => {
  dispatch(clearApiError(scope));
  dispatch(apiRequestStart({
    label,
    scope,
    status
  }));
  try {
    const response = await handler(dispatch);
    dispatch(apiRequestEnd({
      label,
      scope
    }));
    dispatch({
      type: `${label}_SUCCESS`,
      payload: response
    });
    onSuccess(response, dispatch, getState);
  } catch (error) {
    dispatch(apiRequestEnd({
      label,
      scope
    }));
    dispatch(setApiError({
      error,
      scope
    }));
    dispatch({
      type: `${label}_FAILURE`,
      payload: error
    });
    onError(error, dispatch, getState);
  }
};
exports.sendApiRequest = sendApiRequest;