"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerLegacyImportRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerLegacyImportRoute = (router, {
  maxImportPayloadBytes,
  coreUsageData,
  logger,
  access,
  legacyDeprecationInfo
}) => {
  router.post({
    path: '/api/kibana/dashboards/import',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the Saved Objects Client'
      }
    },
    validate: {
      body: _configSchema.schema.object({
        objects: _configSchema.schema.arrayOf(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
        version: _configSchema.schema.maybe(_configSchema.schema.string())
      }),
      query: _configSchema.schema.object({
        force: _configSchema.schema.boolean({
          defaultValue: false
        }),
        exclude: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())], {
          defaultValue: []
        })
      })
    },
    options: {
      access,
      tags: ['api'],
      body: {
        maxBytes: maxImportPayloadBytes
      },
      deprecated: legacyDeprecationInfo
    }
  }, async (context, request, response) => {
    logger.warn("The import dashboard API '/api/kibana/dashboards/import' is deprecated. Use the saved objects import objects API '/api/saved_objects/_import' instead.");
    const {
      client
    } = (await context.core).savedObjects;
    const objects = request.body.objects;
    const {
      force,
      exclude
    } = request.query;
    const usageStatsClient = coreUsageData.getClient();
    usageStatsClient.incrementLegacyDashboardsImport({
      request
    }).catch(() => {});
    const result = await (0, _lib.importDashboards)(client, objects, {
      overwrite: force,
      exclude: Array.isArray(exclude) ? exclude : [exclude]
    });
    return response.ok({
      body: result
    });
  });
};
exports.registerLegacyImportRoute = registerLegacyImportRoute;