"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsImporter = void 0;
var _import_saved_objects = require("./import_saved_objects");
var _resolve_import_errors = require("./resolve_import_errors");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * @internal
 */
var _savedObjectsClient = /*#__PURE__*/new WeakMap();
var _typeRegistry = /*#__PURE__*/new WeakMap();
var _importSizeLimit = /*#__PURE__*/new WeakMap();
var _importHooks = /*#__PURE__*/new WeakMap();
var _log = /*#__PURE__*/new WeakMap();
class SavedObjectsImporter {
  constructor({
    savedObjectsClient,
    typeRegistry,
    importSizeLimit,
    logger
  }) {
    _classPrivateFieldInitSpec(this, _savedObjectsClient, void 0);
    _classPrivateFieldInitSpec(this, _typeRegistry, void 0);
    _classPrivateFieldInitSpec(this, _importSizeLimit, void 0);
    _classPrivateFieldInitSpec(this, _importHooks, void 0);
    _classPrivateFieldInitSpec(this, _log, void 0);
    _classPrivateFieldSet(_savedObjectsClient, this, savedObjectsClient);
    _classPrivateFieldSet(_typeRegistry, this, typeRegistry);
    _classPrivateFieldSet(_importSizeLimit, this, importSizeLimit);
    _classPrivateFieldSet(_importHooks, this, typeRegistry.getAllTypes().reduce((hooks, type) => {
      var _type$management;
      if ((_type$management = type.management) !== null && _type$management !== void 0 && _type$management.onImport) {
        hooks[type.name] = [type.management.onImport];
      }
      return hooks;
    }, {}));
    _classPrivateFieldSet(_log, this, logger);
  }
  import({
    readStream,
    createNewCopies,
    namespace,
    overwrite,
    refresh,
    compatibilityMode,
    managed
  }) {
    return (0, _import_saved_objects.importSavedObjectsFromStream)({
      readStream,
      createNewCopies,
      namespace,
      overwrite,
      refresh,
      compatibilityMode,
      objectLimit: _classPrivateFieldGet(_importSizeLimit, this),
      savedObjectsClient: _classPrivateFieldGet(_savedObjectsClient, this),
      typeRegistry: _classPrivateFieldGet(_typeRegistry, this),
      importHooks: _classPrivateFieldGet(_importHooks, this),
      managed,
      log: _classPrivateFieldGet(_log, this)
    });
  }
  resolveImportErrors({
    readStream,
    createNewCopies,
    compatibilityMode,
    namespace,
    retries,
    managed
  }) {
    _classPrivateFieldGet(_log, this).debug('Resolving import errors');
    return (0, _resolve_import_errors.resolveSavedObjectsImportErrors)({
      readStream,
      createNewCopies,
      compatibilityMode,
      namespace,
      retries,
      objectLimit: _classPrivateFieldGet(_importSizeLimit, this),
      savedObjectsClient: _classPrivateFieldGet(_savedObjectsClient, this),
      typeRegistry: _classPrivateFieldGet(_typeRegistry, this),
      importHooks: _classPrivateFieldGet(_importHooks, this),
      managed
    });
  }
}
exports.SavedObjectsImporter = SavedObjectsImporter;