"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectHeader = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react2 = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _header_action_menu = require("../header/header_action_menu");
var _breadcrumbs = require("./breadcrumbs");
var _header_help_menu = require("../header/header_help_menu");
var _header_nav_controls = require("../header/header_nav_controls");
var _header_top_banner = require("../header/header_top_banner");
var _screen_reader_a11y = require("../header/screen_reader_a11y");
var _app_menu = require("./app_menu");
var _navigation = require("./navigation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getHeaderCss = ({
  size,
  colors
}) => ({
  logo: {
    container: (0, _react.css)`
      display: flex;
      align-items: center;
      justify-content: center;
      min-width: 56px; /* 56 = 40 + 8 + 8 */
      cursor: pointer;
    `,
    logo: (0, _react.css)`
      min-width: 0; /* overrides min-width: 40px */
      padding: 0;
    `,
    spinner: (0, _react.css)`
      position: relative;
      left: 4px;
      top: 2px;
    `
  },
  leftHeaderSection: (0, _react.css)`
    // needed to enable breadcrumbs truncation
    min-width: 0;
    flex-shrink: 1;
  `,
  breadcrumbsSectionItem: (0, _react.css)`
    min-width: 0; // needed to enable breadcrumbs truncation
  `,
  redirectAppLinksContainer: (0, _react.css)`
    min-width: 0; // needed to enable breadcrumbs truncation
  `,
  leftNavcontrols: (0, _react.css)`
    .navcontrols__separator {
      display: flex;
      margin-right: ${size.xs};
      &:after {
        background: ${colors.lightShade};
        content: '';
        flex-shrink: 0;
        margin-block-start: ${size.xs};
        margin-block-end: 0;
        margin-inline: ${size.s};
        block-size: 16px;
        inline-size: 1px;
        transform: translateY(-1px) rotate(15deg);
      }
    }
  `
});
const headerStrings = {
  logo: {
    ariaLabel: _i18n.i18n.translate('core.ui.primaryNav.goToHome.ariaLabel', {
      defaultMessage: 'Go to home page'
    })
  },
  nav: {
    closeNavAriaLabel: _i18n.i18n.translate('core.ui.primaryNav.project.toggleNavAriaLabel', {
      defaultMessage: 'Toggle primary navigation'
    })
  }
};
const LOADING_DEBOUNCE_TIME = 80;
const Logo = ({
  loadingCount$,
  homeHref$,
  prependBasePath,
  application,
  logoCss,
  customBranding$
}) => {
  const loadingCount = (0, _useObservable.default)(loadingCount$.pipe((0, _rxjs.debounceTime)(LOADING_DEBOUNCE_TIME)), 0);
  const homeHref = (0, _useObservable.default)(homeHref$, '/app/home');
  const customBranding = (0, _useObservable.default)(customBranding$, {});
  const {
    logo
  } = customBranding;
  let fullHref;
  if (homeHref) {
    fullHref = prependBasePath(homeHref);
  }
  const navigateHome = (0, _react2.useCallback)(event => {
    if (fullHref) {
      application.navigateToUrl(fullHref);
    }
    event.preventDefault();
  }, [fullHref, application]);
  const renderLogo = () => {
    if (logo) {
      return /*#__PURE__*/_react2.default.createElement("a", {
        href: fullHref,
        onClick: navigateHome,
        "data-test-subj": "globalLoadingIndicator-hidden"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiImage, {
        src: logo,
        css: logoCss,
        "data-test-subj": "globalLoadingIndicator-hidden customLogo",
        size: 24,
        alt: "logo",
        "aria-label": _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.customLogoAriaLabel', {
          defaultMessage: 'User logo'
        })
      }));
    }
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderLogo, {
      iconType: "logoElastic",
      onClick: navigateHome,
      href: fullHref,
      css: logoCss,
      "data-test-subj": "globalLoadingIndicator-hidden",
      "aria-label": headerStrings.logo.ariaLabel
    });
  };
  return /*#__PURE__*/_react2.default.createElement("span", {
    css: logoCss.container,
    "data-test-subj": "nav-header-logo"
  }, loadingCount === 0 ? renderLogo() : /*#__PURE__*/_react2.default.createElement("a", {
    onClick: navigateHome,
    href: fullHref,
    css: logoCss.spinner
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "aria-hidden": false,
    onClick: navigateHome,
    "data-test-subj": "globalLoadingIndicator"
  })));
};
const ProjectHeader = ({
  application,
  kibanaVersion,
  children,
  prependBasePath,
  docLinks,
  toggleSideNav,
  customBranding$,
  isServerless,
  ...observables
}) => {
  const headerActionMenuMounter = (0, _header_action_menu.useHeaderActionMenuMounter)(observables.actionMenu$);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const headerCss = getHeaderCss(euiTheme);
  const {
    logo: logoCss
  } = headerCss;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_screen_reader_a11y.ScreenReaderRouteAnnouncements, {
    breadcrumbs$: observables.breadcrumbs$,
    customBranding$: customBranding$,
    appId$: application.currentAppId$
  }), /*#__PURE__*/_react2.default.createElement(_screen_reader_a11y.SkipToMainContent, null), /*#__PURE__*/_react2.default.createElement(_header_top_banner.HeaderTopBanner, {
    headerBanner$: observables.headerBanner$
  }), /*#__PURE__*/_react2.default.createElement("header", {
    "data-test-subj": "kibanaProjectHeader"
  }, /*#__PURE__*/_react2.default.createElement("div", {
    id: "globalHeaderBars",
    "data-test-subj": "headerGlobalNav",
    className: "header__bars"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeader, {
    position: "fixed",
    className: "header__firstBar"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSection, {
    grow: false,
    css: headerCss.leftHeaderSection
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxRouter.Router, {
    history: application.history
  }, /*#__PURE__*/_react2.default.createElement(_navigation.ProjectNavigation, {
    isSideNavCollapsed$: observables.isSideNavCollapsed$,
    toggleSideNav: toggleSideNav
  }, children)), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(Logo, {
    prependBasePath: prependBasePath,
    application: application,
    homeHref$: observables.homeHref$,
    loadingCount$: observables.loadingCount$,
    customBranding$: customBranding$,
    logoCss: logoCss
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, {
    css: headerCss.leftNavcontrols
  }, /*#__PURE__*/_react2.default.createElement(_header_nav_controls.HeaderNavControls, {
    side: "left",
    navControls$: observables.navControlsLeft$,
    append: /*#__PURE__*/_react2.default.createElement("div", {
      className: "navcontrols__separator"
    })
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, {
    css: headerCss.breadcrumbsSectionItem
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    },
    css: headerCss.redirectAppLinksContainer
  }, /*#__PURE__*/_react2.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs$: observables.breadcrumbs$
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSection, {
    side: "right"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(_header_nav_controls.HeaderNavControls, {
    navControls$: observables.navControlsCenter$
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(_header_help_menu.HeaderHelpMenu, {
    isServerless: isServerless,
    globalHelpExtensionMenuLinks$: observables.globalHelpExtensionMenuLinks$,
    helpExtension$: observables.helpExtension$,
    helpSupportUrl$: observables.helpSupportUrl$,
    defaultContentLinks$: observables.helpMenuLinks$,
    kibanaDocLink: docLinks.links.elasticStackGetStarted,
    docLinks: docLinks,
    kibanaVersion: kibanaVersion,
    navigateToUrl: application.navigateToUrl
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react2.default.createElement(_header_nav_controls.HeaderNavControls, {
    navControls$: observables.navControlsRight$
  })))))), headerActionMenuMounter.mount && /*#__PURE__*/_react2.default.createElement(_app_menu.AppMenuBar, {
    headerActionMenuMounter: headerActionMenuMounter
  }));
};
exports.ProjectHeader = ProjectHeader;