"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeHideExcludeAndHideExists = exports.makeControlOrdersZeroBased = void 0;
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const makeControlOrdersZeroBased = state => {
  if (state.panels && typeof state.panels === 'object' && Object.keys(state.panels).length > 0 && !Object.values(state.panels).find(panel => {
    var _panel$order;
    return ((_panel$order = panel === null || panel === void 0 ? void 0 : panel.order) !== null && _panel$order !== void 0 ? _panel$order : 0) === 0;
  })) {
    // 0th element could not be found. Reorder all panels from 0;
    const newPanels = Object.entries(state.panels).sort(([, a], [, b]) => a.order > b.order ? 1 : -1).map(([id, panel], index) => {
      panel.order = index;
      return {
        id,
        panel
      };
    }).reduce((acc, {
      id,
      panel: currentPanel
    }) => {
      acc[id] = currentPanel;
      return acc;
    }, {});
    state.panels = newPanels;
  }
  return state;
};

/**
 * The UX for the "Allow include/exclude" and "Allow exists query" toggles was removed in 8.7.0 so, to
 * prevent users from getting stuck when migrating from 8.6.0 (when the toggles were introduced) to 8.7.0
 * we must set both the `hideExclude` and `hideExists` keys to `undefined` for all existing options
 * list controls.
 */
exports.makeControlOrdersZeroBased = makeControlOrdersZeroBased;
const removeHideExcludeAndHideExists = state => {
  if (state.panels && typeof state.panels === 'object' && Object.keys(state.panels).length > 0) {
    const newPanels = Object.keys(state.panels).reduce((panelAccumulator, panelId) => {
      const panel = state.panels[panelId];
      if (panel.type === _common.OPTIONS_LIST_CONTROL) {
        const explicitInput = panel.explicitInput;
        delete explicitInput.hideExclude;
        delete explicitInput.hideExists;
      }
      return {
        ...panelAccumulator,
        [panelId]: panel
      };
    }, {});
    state.panels = newPanels;
  }
  return state;
};
exports.removeHideExcludeAndHideExists = removeHideExcludeAndHideExists;