"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initTimeRangePercentage = initTimeRangePercentage;
exports.timeRangePercentageComparators = void 0;
var _rxjs = require("rxjs");
var _time_utils = require("./time_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const timeRangePercentageComparators = exports.timeRangePercentageComparators = {
  timesliceStartAsPercentageOfTimeRange: 'referenceEquality',
  timesliceEndAsPercentageOfTimeRange: 'referenceEquality'
};
function initTimeRangePercentage(state, onReset) {
  const timesliceStartAsPercentageOfTimeRange$ = new _rxjs.BehaviorSubject(state.timesliceStartAsPercentageOfTimeRange);
  const timesliceEndAsPercentageOfTimeRange$ = new _rxjs.BehaviorSubject(state.timesliceEndAsPercentageOfTimeRange);
  return {
    setTimeRangePercentage(timeslice, timeRangeMeta) {
      let timesliceStartAsPercentageOfTimeRange;
      let timesliceEndAsPercentageOfTimeRange;
      if (timeslice) {
        timesliceStartAsPercentageOfTimeRange = (timeslice[_time_utils.FROM_INDEX] - timeRangeMeta.timeRangeBounds[_time_utils.FROM_INDEX]) / timeRangeMeta.timeRange;
        timesliceEndAsPercentageOfTimeRange = (timeslice[_time_utils.TO_INDEX] - timeRangeMeta.timeRangeBounds[_time_utils.FROM_INDEX]) / timeRangeMeta.timeRange;
      }
      timesliceStartAsPercentageOfTimeRange$.next(timesliceStartAsPercentageOfTimeRange);
      timesliceEndAsPercentageOfTimeRange$.next(timesliceEndAsPercentageOfTimeRange);
    },
    getLatestState: () => {
      return {
        timesliceStartAsPercentageOfTimeRange: timesliceStartAsPercentageOfTimeRange$.value,
        timesliceEndAsPercentageOfTimeRange: timesliceEndAsPercentageOfTimeRange$.value
      };
    },
    anyStateChange$: (0, _rxjs.merge)(timesliceStartAsPercentageOfTimeRange$, timesliceEndAsPercentageOfTimeRange$).pipe((0, _rxjs.map)(() => undefined)),
    reinitializeState: lastSaved => {
      timesliceStartAsPercentageOfTimeRange$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.timesliceStartAsPercentageOfTimeRange);
      timesliceEndAsPercentageOfTimeRange$.next(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.timesliceEndAsPercentageOfTimeRange);
      onReset(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.timesliceStartAsPercentageOfTimeRange, lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.timesliceEndAsPercentageOfTimeRange);
    }
  };
}