"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.controlFetch$ = controlFetch$;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function controlFetch$(chaining$, controlGroupFetch$) {
  return (0, _rxjs.combineLatest)([chaining$, controlGroupFetch$]).pipe((0, _rxjs.debounceTime)(0), (0, _rxjs.map)(([chainingContext, controlGroupFetchContext]) => {
    var _chainingContext$time;
    const filters = [];
    if (controlGroupFetchContext.unifiedSearchFilters) {
      filters.push(...controlGroupFetchContext.unifiedSearchFilters);
    }
    if (chainingContext.chainingFilters) {
      filters.push(...chainingContext.chainingFilters);
    }
    return {
      filters,
      query: controlGroupFetchContext.query,
      timeRange: (_chainingContext$time = chainingContext.timeRange) !== null && _chainingContext$time !== void 0 ? _chainingContext$time : controlGroupFetchContext.timeRange
    };
  }));
}