"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkRequestStatusBar = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const mapStatusCodeToBadgeColor = statusCode => {
  if (statusCode <= 199) {
    return 'default';
  }
  if (statusCode <= 299) {
    return 'success';
  }
  if (statusCode <= 399) {
    return 'primary';
  }
  if (statusCode <= 499) {
    return 'warning';
  }
  return 'danger';
};
const NetworkRequestStatusBar = ({
  requestInProgress,
  requestResult
}) => {
  let content = null;
  if (requestInProgress) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('console.requestInProgressBadgeText', {
      defaultMessage: 'Request in progress'
    })));
  } else if (requestResult) {
    const {
      endpoint,
      method,
      statusCode,
      statusText,
      timeElapsedMs
    } = requestResult;
    content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, `${method} ${endpoint.startsWith('/') ? endpoint : '/' + endpoint}`)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "consoleResponseStatusBadge",
      color: mapStatusCodeToBadgeColor(statusCode)
    }, statusCode, "\xA0-\xA0", statusText))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('console.requestTimeElapasedBadgeTooltipContent', {
        defaultMessage: 'Time Elapsed'
      }))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "default"
    }, timeElapsedMs, "\xA0", 'ms')))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    direction: "row",
    gutterSize: "s",
    responsive: false
  }, content);
};
exports.NetworkRequestStatusBar = NetworkRequestStatusBar;