"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleCasesAnalyticsSyncTask = exports.createCasesAnalyticsIndex = void 0;
var _analytics_index = require("../analytics_index");
var _constants = require("./constants");
var _mappings = require("./mappings");
var _painless_scripts = require("./painless_scripts");
var _synchronization_task = require("../tasks/synchronization_task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCasesAnalyticsIndex = ({
  esClient,
  logger,
  isServerless,
  taskManager
}) => new _analytics_index.AnalyticsIndex({
  logger,
  esClient,
  isServerless,
  taskManager,
  indexName: _constants.CAI_CASES_INDEX_NAME,
  indexAlias: _constants.CAI_CASES_INDEX_ALIAS,
  indexVersion: _constants.CAI_CASES_INDEX_VERSION,
  mappings: _mappings.CAI_CASES_INDEX_MAPPINGS,
  painlessScriptId: _painless_scripts.CAI_CASES_INDEX_SCRIPT_ID,
  painlessScript: _painless_scripts.CAI_CASES_INDEX_SCRIPT,
  taskId: _constants.CAI_CASES_BACKFILL_TASK_ID,
  sourceIndex: _constants.CAI_CASES_SOURCE_INDEX,
  sourceQuery: _constants.CAI_CASES_SOURCE_QUERY
});
exports.createCasesAnalyticsIndex = createCasesAnalyticsIndex;
const scheduleCasesAnalyticsSyncTask = ({
  taskManager,
  logger
}) => {
  (0, _synchronization_task.scheduleCAISynchronizationTask)({
    taskId: _constants.CAI_CASES_SYNCHRONIZATION_TASK_ID,
    sourceIndex: _constants.CAI_CASES_SOURCE_INDEX,
    destIndex: _constants.CAI_CASES_INDEX_NAME,
    taskManager,
    logger
  }).catch(e => {
    logger.error(`Error scheduling ${_constants.CAI_CASES_SYNCHRONIZATION_TASK_ID} task, received ${e.message}`);
  });
};
exports.scheduleCasesAnalyticsSyncTask = scheduleCasesAnalyticsSyncTask;