"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldMappingRowStatic = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldMappingRowComponent = ({
  isLoading,
  casesField,
  selectedActionType,
  selectedThirdParty
}) => {
  const selectedActionTypeCapitalized = (0, _react.useMemo)(() => (0, _fp.capitalize)(selectedActionType), [selectedActionType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "static-mappings",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    "data-test-subj": "field-mapping-source"
  }, casesField)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    "data-test-subj": "field-mapping-target"
  }, selectedThirdParty)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : selectedActionTypeCapitalized));
};
FieldMappingRowComponent.displayName = 'FieldMappingRow';
const FieldMappingRowStatic = exports.FieldMappingRowStatic = /*#__PURE__*/_react.default.memo(FieldMappingRowComponent);