"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsAddToCaseOpen = void 0;
var _cases_state_context = require("./cases_state_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook is to check if the "add to case" is open, either the modal or the flyout
 */
const useIsAddToCaseOpen = () => {
  const {
    selectCaseModal,
    createCaseFlyout
  } = (0, _cases_state_context.useCasesStateContext)();
  return selectCaseModal.isModalOpen || createCaseFlyout.isFlyoutOpen;
};
exports.useIsAddToCaseOpen = useIsAddToCaseOpen;