"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesColumnsConfiguration = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
var _translations2 = require("../../common/translations");
var _use_cases_features = require("../../common/use_cases_features");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesColumnsConfiguration = isSelectorView => {
  const {
    isAlertsEnabled,
    caseAssignmentAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    data: {
      customFields
    }
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const canDisplayDefault = true;
  const result = {
    title: {
      field: 'title',
      name: i18n.NAME,
      canDisplay: canDisplayDefault,
      isCheckedDefault: true
    },
    assignees: {
      field: 'assignees',
      name: i18n.ASSIGNEES,
      canDisplay: caseAssignmentAuthorized && !isSelectorView,
      isCheckedDefault: true
    },
    tags: {
      field: 'tags',
      name: i18n.TAGS,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: true
    },
    totalAlerts: {
      field: 'totalAlerts',
      name: _translations2.ALERTS,
      canDisplay: isAlertsEnabled && !isSelectorView,
      isCheckedDefault: true
    },
    totalComment: {
      field: 'totalComment',
      name: i18n.COMMENTS,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: true
    },
    category: {
      field: 'category',
      name: i18n.CATEGORY,
      canDisplay: canDisplayDefault,
      isCheckedDefault: true
    },
    closedAt: {
      field: 'closedAt',
      name: i18n.CLOSED_ON,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: false
    },
    createdAt: {
      field: 'createdAt',
      name: i18n.CREATED_ON,
      canDisplay: canDisplayDefault,
      isCheckedDefault: true
    },
    updatedAt: {
      field: 'updatedAt',
      name: i18n.UPDATED_ON,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: true
    },
    externalIncident: {
      field: 'externalIncident',
      name: i18n.EXTERNAL_INCIDENT,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: true
    },
    status: {
      field: 'status',
      name: i18n.STATUS,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: true
    },
    severity: {
      field: 'severity',
      name: i18n.SEVERITY,
      canDisplay: canDisplayDefault,
      isCheckedDefault: true
    }
  };

  // we need to extend the configuration with the customFields
  customFields.forEach(({
    key,
    label
  }) => {
    result[key] = {
      field: key,
      name: label,
      canDisplay: canDisplayDefault && !isSelectorView,
      isCheckedDefault: false
    };
  });
  return result;
};
exports.useCasesColumnsConfiguration = useCasesColumnsConfiguration;