"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionInput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Input = (0, _public.withSuspense)(_public.LazyExpressionInput);
const ExpressionInput = ({
  error,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasExpressionInput",
    "data-test-subj": "canvasExpressionInput"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    className: "canvasExpressionInput__inner",
    fullWidth: true,
    isInvalid: Boolean(error),
    error: error
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasExpressionInput__editor"
  }, /*#__PURE__*/_react.default.createElement(Input, (0, _extends2.default)({
    height: "100%"
  }, rest)))));
};
exports.ExpressionInput = ExpressionInput;