"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shape = void 0;
var _shape = require("../../renderers/shape");
var _shape2 = require("../../../i18n/functions/dict/shape");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const shape = () => {
  const {
    help,
    args: argHelp
  } = _shape2.help;
  return {
    name: 'shape',
    aliases: [],
    inputTypes: ['null'],
    help,
    args: {
      shape: {
        types: ['string'],
        help: argHelp.shape,
        aliases: ['_'],
        default: 'square',
        options: Object.values(_shape.Shape)
      },
      border: {
        types: ['string'],
        aliases: ['stroke'],
        help: argHelp.border
      },
      borderWidth: {
        types: ['number'],
        aliases: ['strokeWidth'],
        help: argHelp.borderWidth,
        default: 0
      },
      fill: {
        types: ['string'],
        help: argHelp.fill,
        default: 'black'
      },
      maintainAspect: {
        types: ['boolean'],
        help: argHelp.maintainAspect,
        default: false,
        options: [true, false]
      }
    },
    fn: (_, args) => {
      const avaliableShapes = (0, _shape.getAvailableShapes)();
      if (!avaliableShapes.includes(args.shape)) {
        throw _shape2.errors.invalidShape(args.shape);
      }
      return {
        type: 'shape',
        ...args
      };
    }
  };
};
exports.shape = shape;