"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchStreaming = fetchStreaming;
var _rxjs = require("rxjs");
var _ = require(".");
var _from_streaming_xhr = require("./from_streaming_xhr");
var _split = require("./split");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Sends an AJAX request to the server, and processes the result as a
 * streaming HTTP/1 response. Streams data as text through observable.
 */
function fetchStreaming({
  url,
  headers = {},
  method = 'POST',
  body = '',
  signal,
  getIsCompressionDisabled = () => false
}) {
  const xhr = new window.XMLHttpRequest();
  const isCompressionDisabled = getIsCompressionDisabled();
  if (!isCompressionDisabled) {
    url = (0, _common.appendQueryParam)(url, 'compress', 'true');
  }
  // Begin the request
  xhr.open(method, url);
  xhr.withCredentials = true;

  // Set the HTTP headers
  Object.entries(headers).forEach(([k, v]) => xhr.setRequestHeader(k, v));
  const stream = (0, _from_streaming_xhr.fromStreamingXhr)(xhr, signal);

  // Send the payload to the server
  xhr.send(body);

  // Return a stream of chunked decompressed messages
  const stream$ = stream.pipe((0, _split.split)('\n'), (0, _rxjs.map)(msg => {
    return isCompressionDisabled ? msg : (0, _.inflateResponse)(msg);
  }), (0, _rxjs.share)());
  return {
    xhr,
    stream: stream$
  };
}