"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileMostUsedCharts = getMobileMostUsedCharts;
var _merge_other_count = require("./merge_other_count");
var _mobile_types = require("../../../../common/mobile_types");
var _get_device_os_app = require("../get_device_os_app");
var _get_nct = require("../get_nct");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getMobileMostUsedCharts({
  kuery,
  apmEventClient,
  serviceName,
  transactionType,
  environment,
  start,
  end
}) {
  var _mobileTransactionEve, _mobileTransactionEve2, _mobileTransactionEve3, _mobileTransactionEve4, _mobileTransactionEve5, _mobileTransactionEve6, _mobileTransactionEve7, _mobileTransactionEve8, _mobileTransactionEve9, _mobileTransactionEve10, _mobileTransactionEve11, _mobileTransactionEve12, _mobileNetworkConnect, _mobileNetworkConnect2, _mobileNetworkConnect3, _mobileNetworkConnect4;
  const MAX_ITEMS_PER_CHART = 5;
  const commonProps = {
    kuery,
    apmEventClient,
    serviceName,
    transactionType,
    environment,
    start,
    end,
    size: MAX_ITEMS_PER_CHART
  };
  const [mobileTransactionEventsResponse, mobileNetworkConnectionTypeResponse] = await Promise.all([(0, _get_device_os_app.getDeviceOSApp)(commonProps), (0, _get_nct.getNCT)(commonProps)]);
  return [{
    key: _mobile_types.MobileProperty.Device,
    options: (0, _merge_other_count.mergeCountWithOther)((_mobileTransactionEve = mobileTransactionEventsResponse.aggregations) === null || _mobileTransactionEve === void 0 ? void 0 : (_mobileTransactionEve2 = _mobileTransactionEve.devices) === null || _mobileTransactionEve2 === void 0 ? void 0 : _mobileTransactionEve2.buckets, (_mobileTransactionEve3 = mobileTransactionEventsResponse.aggregations) === null || _mobileTransactionEve3 === void 0 ? void 0 : (_mobileTransactionEve4 = _mobileTransactionEve3.devices) === null || _mobileTransactionEve4 === void 0 ? void 0 : _mobileTransactionEve4.sum_other_doc_count) || []
  }, {
    key: _mobile_types.MobileProperty.OsVersion,
    options: (0, _merge_other_count.mergeCountWithOther)((_mobileTransactionEve5 = mobileTransactionEventsResponse.aggregations) === null || _mobileTransactionEve5 === void 0 ? void 0 : (_mobileTransactionEve6 = _mobileTransactionEve5.osVersions) === null || _mobileTransactionEve6 === void 0 ? void 0 : _mobileTransactionEve6.buckets, (_mobileTransactionEve7 = mobileTransactionEventsResponse.aggregations) === null || _mobileTransactionEve7 === void 0 ? void 0 : (_mobileTransactionEve8 = _mobileTransactionEve7.osVersions) === null || _mobileTransactionEve8 === void 0 ? void 0 : _mobileTransactionEve8.sum_other_doc_count) || []
  }, {
    key: _mobile_types.MobileProperty.AppVersion,
    options: (0, _merge_other_count.mergeCountWithOther)((_mobileTransactionEve9 = mobileTransactionEventsResponse.aggregations) === null || _mobileTransactionEve9 === void 0 ? void 0 : (_mobileTransactionEve10 = _mobileTransactionEve9.appVersions) === null || _mobileTransactionEve10 === void 0 ? void 0 : _mobileTransactionEve10.buckets, (_mobileTransactionEve11 = mobileTransactionEventsResponse.aggregations) === null || _mobileTransactionEve11 === void 0 ? void 0 : (_mobileTransactionEve12 = _mobileTransactionEve11.appVersions) === null || _mobileTransactionEve12 === void 0 ? void 0 : _mobileTransactionEve12.sum_other_doc_count) || []
  }, {
    key: _mobile_types.MobileProperty.NetworkConnectionType,
    options: (0, _merge_other_count.mergeCountWithOther)((_mobileNetworkConnect = mobileNetworkConnectionTypeResponse.aggregations) === null || _mobileNetworkConnect === void 0 ? void 0 : (_mobileNetworkConnect2 = _mobileNetworkConnect.netConnectionTypes) === null || _mobileNetworkConnect2 === void 0 ? void 0 : _mobileNetworkConnect2.buckets, (_mobileNetworkConnect3 = mobileNetworkConnectionTypeResponse.aggregations) === null || _mobileNetworkConnect3 === void 0 ? void 0 : (_mobileNetworkConnect4 = _mobileNetworkConnect3.netConnectionTypes) === null || _mobileNetworkConnect4 === void 0 ? void 0 : _mobileNetworkConnect4.sum_other_doc_count) || []
  }];
}