"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableSearchBar = TableSearchBar;
exports.getItemsFilteredBySearchQuery = getItemsFilteredBySearchQuery;
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _technical_preview_badge = require("../technical_preview_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TableSearchBar({
  placeholder,
  searchQuery,
  onChangeSearchQuery,
  isLoading,
  techPreview = false
}) {
  const debouncedSearchQuery = (0, _react.useMemo)(() => (0, _lodash.debounce)(onChangeSearchQuery, 500), [onChangeSearchQuery]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, techPreview ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            justify-content: center;
          `
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    icon: "beaker"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "tableSearchInput",
    placeholder: placeholder,
    fullWidth: true,
    defaultValue: searchQuery,
    isLoading: isLoading,
    onChange: e => {
      debouncedSearchQuery(e.target.value);
    }
  })));
}
function getItemsFilteredBySearchQuery({
  items,
  fieldsToSearch,
  searchQuery
}) {
  const query = searchQuery.toLowerCase();
  return items.filter(item => {
    return fieldsToSearch.some(field => {
      const fieldValue = item[field];
      return fieldValue === null || fieldValue === void 0 ? void 0 : fieldValue.toLowerCase().includes(query);
    });
  });
}