"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyMessage = EmptyMessage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmptyMessage({
  heading = _i18n.i18n.translate('xpack.apm.emptyMessage.noDataFoundLabel', {
    defaultMessage: 'No data found.'
  }),
  subheading = _i18n.i18n.translate('xpack.apm.emptyMessage.noDataFoundDescription', {
    defaultMessage: 'Try another time range or reset the search filter.'
  }),
  hideSubheading = false
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("div", null, heading),
    body: !hideSubheading && subheading
  });
}