"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPlotValues = getPlotValues;
var _d3Scale = require("d3-scale");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPlotValues({
  width,
  xMin = 0,
  xMax,
  margins,
  numberOfTicks = 7
}) {
  const xScale = (0, _d3Scale.scaleLinear)().domain([xMin, xMax]).range([margins.left, width - margins.right]);
  return {
    margins,
    tickValues: xScale.ticks(numberOfTicks),
    width,
    xDomain: xScale.domain(),
    xMax,
    xScale
  };
}