"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTimeseriesEmpty = isTimeseriesEmpty;
exports.onBrushEnd = void 0;
var _url_helpers = require("../../links/url_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onBrushEnd = ({
  x,
  history
}) => {
  if (x) {
    const start = x[0];
    const end = x[1];
    const currentSearch = (0, _url_helpers.toQuery)(history.location.search);
    const nextSearch = {
      rangeFrom: new Date(start).toISOString(),
      rangeTo: new Date(end).toISOString()
    };
    history.push({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...currentSearch,
        ...nextSearch
      })
    });
  }
};
exports.onBrushEnd = onBrushEnd;
function isTimeseriesEmpty(timeseries) {
  return !timeseries || timeseries.length === 0 || timeseries.map(serie => serie.data).flat().every(({
    y
  }) => y === null || y === undefined);
}