"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailureBadge = FailureBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_theme = require("../../../../../../hooks/use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResetLineHeight = _common.euiStyled.span`
  line-height: initial;
`;
function FailureBadge({
  outcome
}) {
  const theme = (0, _use_theme.useTheme)();
  if (outcome !== 'failure') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ResetLineHeight, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.apm.failure_badge.tooltip', {
      defaultMessage: 'event.outcome = failure'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: theme.eui.euiColorDanger
  }, "failure")));
}