"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentMarks = getAgentMarks;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Extends Mark without adding new properties to it.

function getAgentMarks(transaction) {
  var _transaction$transact;
  const agent = transaction === null || transaction === void 0 ? void 0 : (_transaction$transact = transaction.transaction.marks) === null || _transaction$transact === void 0 ? void 0 : _transaction$transact.agent;
  if (!agent) {
    return [];
  }
  return (0, _lodash.sortBy)(Object.entries(agent).map(([name, ms]) => ({
    type: 'agentMark',
    id: name,
    offset: ms * 1000,
    verticalLine: true
  })), 'offset');
}