"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallContainer = WaterfallContainer;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _url_helpers = require("../../../../shared/links/url_helpers");
var _waterfall = require("./waterfall");
var _orphan_trace_items_warning = require("./waterfall/orphan_trace_items_warning");
var _waterfall_flyout = require("./waterfall/waterfall_flyout");
var _waterfall_legends = require("./waterfall_legends");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toggleFlyout = ({
  history,
  item,
  flyoutDetailTab
}) => {
  history.replace({
    ...history.location,
    search: (0, _url_helpers.fromQuery)({
      ...(0, _url_helpers.toQuery)(location.search),
      flyoutDetailTab,
      waterfallItemId: item === null || item === void 0 ? void 0 : item.id
    })
  });
};
function WaterfallContainer({
  serviceName,
  waterfallItemId,
  waterfall,
  showCriticalPath,
  onShowCriticalPathChange
}) {
  const history = (0, _reactRouterDom.useHistory)();
  if (!waterfall) {
    return null;
  }
  const {
    legends,
    colorBy,
    orphanTraceItemsCount
  } = waterfall;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "showCriticalPath",
    label: _i18n.i18n.translate('xpack.apm.waterfall.showCriticalPath', {
      defaultMessage: 'Show critical path'
    }),
    checked: showCriticalPath,
    onChange: event => {
      onShowCriticalPathChange(event.target.checked);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_waterfall_legends.WaterfallLegends, {
    serviceName: serviceName,
    legends: legends,
    type: colorBy
  })), orphanTraceItemsCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_orphan_trace_items_warning.OrphanTraceItemsWarning, {
    orphanTraceItemsCount: orphanTraceItemsCount
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_waterfall.Waterfall, {
    showCriticalPath: showCriticalPath,
    waterfallItemId: waterfallItemId,
    waterfall: waterfall,
    onNodeClick: (item, flyoutDetailTab) => toggleFlyout({
      history,
      item,
      flyoutDetailTab
    })
  })), /*#__PURE__*/_react.default.createElement(_waterfall_flyout.WaterfallFlyout, {
    waterfallItemId: waterfallItemId,
    waterfall: waterfall,
    toggleFlyout: toggleFlyout
  }));
}