"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupsCard = ServiceGroupsCard;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _service_groups = require("../../../../../common/service_groups");
var _kibana = require("../../../shared/links/kibana");
var _service_stat = require("./service_stat");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceGroupsCard({
  serviceGroup,
  href,
  serviceGroupCounts,
  isLoading
}) {
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const activeAlertsHref = (0, _kibana.useObservabilityActiveAlertsHref)(serviceGroup.kuery);
  const cardProps = {
    style: {
      width: isMobile ? '100%' : 286
    },
    icon: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      name: serviceGroup.groupName,
      color: serviceGroup.color || _service_groups.SERVICE_GROUP_COLOR_DEFAULT,
      size: "l"
    })),
    title: serviceGroup.groupName,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: 'column',
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, serviceGroup.description || _i18n.i18n.translate('xpack.apm.serviceGroups.cardsList.emptyDescription', {
      defaultMessage: 'No description available'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_service_stat.ServiceStat, {
      loading: isLoading
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "left"
    }, serviceGroupCounts !== undefined && _i18n.i18n.translate('xpack.apm.serviceGroups.cardsList.serviceCount', {
      defaultMessage: '{servicesCount} {servicesCount, plural, one {service} other {services}}',
      values: {
        servicesCount: serviceGroupCounts.services
      }
    })))), /*#__PURE__*/_react.default.createElement(_service_stat.ServiceStat, {
      loading: isLoading,
      grow: isLoading
    }, serviceGroupCounts && serviceGroupCounts.alerts > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: _i18n.i18n.translate('xpack.apm.home.serviceGroups.tooltip.activeAlertsExplanation', {
        defaultMessage: 'Active alerts'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconType: "warning",
      color: "danger",
      href: activeAlertsHref,
      onClick(e) {
        e.stopPropagation(); // prevents extra click thru to EuiCard's href destination
      }
    }, _i18n.i18n.translate('xpack.apm.serviceGroups.cardsList.alertCount', {
      defaultMessage: '{alertsCount} {alertsCount, plural, one {alert} other {alerts}}',
      values: {
        alertsCount: serviceGroupCounts.alerts
      }
    })))))),
    href
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: serviceGroup.groupName,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, (0, _extends2.default)({
    layout: "vertical"
  }, cardProps, {
    "data-test-subj": "serviceGroupCard"
  })));
}