"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleAttributesToEncrypt = exports.RuleAttributesIncludedInAAD = exports.RULE_SAVED_OBJECT_TYPE = exports.AdHocRunAttributesToEncrypt = exports.AdHocRunAttributesIncludedInAAD = exports.API_KEY_PENDING_INVALIDATION_TYPE = exports.AD_HOC_RUN_SAVED_OBJECT_TYPE = void 0;
Object.defineProperty(exports, "partiallyUpdateRule", {
  enumerable: true,
  get: function () {
    return _partially_update_rule.partiallyUpdateRule;
  }
});
Object.defineProperty(exports, "partiallyUpdateRuleWithEs", {
  enumerable: true,
  get: function () {
    return _partially_update_rule.partiallyUpdateRuleWithEs;
  }
});
exports.setupSavedObjects = setupSavedObjects;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _mappings = require("../../common/saved_objects/rules/mappings");
var _rules_settings_mappings = require("./rules_settings_mappings");
var _maintenance_window_mapping = require("./maintenance_window_mapping");
var _migrations = require("./migrations");
var _transform_rule_for_export = require("./transform_rule_for_export");
var _get_import_warnings = require("./get_import_warnings");
var _is_rule_exportable = require("./is_rule_exportable");
var _partially_update_rule = require("./partially_update_rule");
var _common = require("../../common");
var _model_versions = require("./model_versions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_SAVED_OBJECT_TYPE = exports.RULE_SAVED_OBJECT_TYPE = 'alert';
const AD_HOC_RUN_SAVED_OBJECT_TYPE = exports.AD_HOC_RUN_SAVED_OBJECT_TYPE = 'ad_hoc_run_params';
const API_KEY_PENDING_INVALIDATION_TYPE = exports.API_KEY_PENDING_INVALIDATION_TYPE = 'api_key_pending_invalidation';
const RuleAttributesToEncrypt = exports.RuleAttributesToEncrypt = ['apiKey'];

// Use caution when removing items from this array! These fields
// are used to construct decryption AAD and must be remain in
// this array to prevent decryption failures during migration.
// NOTE: Always update the RuleAttributesNotPartiallyUpdatable
// type if this const changes!
const RuleAttributesIncludedInAAD = exports.RuleAttributesIncludedInAAD = ['enabled', 'name', 'tags', 'alertTypeId', 'consumer', 'legacyId', 'schedule', 'actions', 'params', 'mapped_params', 'createdBy', 'createdAt', 'apiKeyOwner', 'apiKeyCreatedByUser', 'throttle', 'notifyWhen', 'meta', 'alertDelay'];

// useful type for Omit<RuleAttributes, [...RuleAttributesToEncrypt, ...RuleAttributesIncludedInAAD]>
// which will produce a subset of RuleAttributes with just attributes that are safe to partually
// update from AAD

const AdHocRunAttributesToEncrypt = exports.AdHocRunAttributesToEncrypt = ['apiKeyToUse'];
const AdHocRunAttributesIncludedInAAD = exports.AdHocRunAttributesIncludedInAAD = ['rule', 'spaceId'];
function setupSavedObjects(savedObjects, encryptedSavedObjects, ruleTypeRegistry, logger, isPreconfigured, getSearchSourceMigrations) {
  savedObjects.registerType({
    name: RULE_SAVED_OBJECT_TYPE,
    indexPattern: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
    hidden: true,
    namespaceType: 'multiple-isolated',
    convertToMultiNamespaceTypeVersion: '8.0.0',
    migrations: (0, _migrations.getMigrations)(encryptedSavedObjects, getSearchSourceMigrations(), isPreconfigured),
    mappings: _mappings.alertMappings,
    management: {
      displayName: 'rule',
      importableAndExportable: true,
      getTitle(ruleSavedObject) {
        return `Rule: [${ruleSavedObject.attributes.name}]`;
      },
      onImport(ruleSavedObjects) {
        return {
          warnings: (0, _get_import_warnings.getImportWarnings)(ruleSavedObjects)
        };
      },
      onExport(context, objects) {
        return (0, _transform_rule_for_export.transformRulesForExport)(objects);
      },
      isExportable(ruleSavedObject) {
        return (0, _is_rule_exportable.isRuleExportable)(ruleSavedObject, ruleTypeRegistry, logger);
      }
    },
    modelVersions: _model_versions.ruleModelVersions
  });
  savedObjects.registerType({
    name: API_KEY_PENDING_INVALIDATION_TYPE,
    indexPattern: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
    hidden: true,
    namespaceType: 'agnostic',
    mappings: {
      properties: {
        apiKeyId: {
          type: 'keyword'
        },
        createdAt: {
          type: 'date'
        }
      }
    },
    modelVersions: _model_versions.apiKeyPendingInvalidationModelVersions
  });
  savedObjects.registerType({
    name: _common.RULES_SETTINGS_SAVED_OBJECT_TYPE,
    indexPattern: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
    hidden: true,
    namespaceType: 'single',
    mappings: _rules_settings_mappings.rulesSettingsMappings,
    modelVersions: _model_versions.rulesSettingsModelVersions
  });
  savedObjects.registerType({
    name: _common.MAINTENANCE_WINDOW_SAVED_OBJECT_TYPE,
    indexPattern: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
    hidden: true,
    namespaceType: 'multiple-isolated',
    mappings: _maintenance_window_mapping.maintenanceWindowMappings,
    modelVersions: _model_versions.maintenanceWindowModelVersions
  });
  savedObjects.registerType({
    name: AD_HOC_RUN_SAVED_OBJECT_TYPE,
    indexPattern: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
    hidden: true,
    namespaceType: 'multiple-isolated',
    mappings: {
      dynamic: false,
      properties: {
        apiKeyId: {
          type: 'keyword'
        },
        createdAt: {
          type: 'date'
        },
        end: {
          type: 'date'
        },
        rule: {
          properties: {
            alertTypeId: {
              type: 'keyword'
            },
            consumer: {
              type: 'keyword'
            }
          }
        },
        start: {
          type: 'date'
        }
        // TODO to allow searching/filtering by status
        // status: {
        //   type: 'keyword'
        // }
      }
    },
    management: {
      importableAndExportable: false
    },
    modelVersions: _model_versions.adHocRunParamsModelVersions
  });

  // Encrypted attributes
  encryptedSavedObjects.registerType({
    type: RULE_SAVED_OBJECT_TYPE,
    /**
     * We disable enforcing random SO IDs for the rule SO
     * to allow users creating rules with a predefined ID.
     */
    enforceRandomId: false,
    attributesToEncrypt: new Set(RuleAttributesToEncrypt),
    attributesToIncludeInAAD: new Set(RuleAttributesIncludedInAAD)
  });

  // Encrypted attributes
  encryptedSavedObjects.registerType({
    type: API_KEY_PENDING_INVALIDATION_TYPE,
    attributesToEncrypt: new Set(['apiKeyId']),
    attributesToIncludeInAAD: new Set(['createdAt'])
  });

  // Encrypted attributes
  encryptedSavedObjects.registerType({
    type: AD_HOC_RUN_SAVED_OBJECT_TYPE,
    attributesToEncrypt: new Set(AdHocRunAttributesToEncrypt),
    attributesToIncludeInAAD: new Set(AdHocRunAttributesIncludedInAAD)
  });
}