"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertingAuthorizationClientFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _alerting_authorization = require("./authorization/alerting_authorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AlertingAuthorizationClientFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "isInitialized", false);
    // The reason this is protected is because we'll get type collisions otherwise because we're using a type guard assert
    // to ensure the options member is instantiated before using it in various places
    // See for more info: https://stackoverflow.com/questions/66206180/typescript-typeguard-attribut-with-method
    (0, _defineProperty2.default)(this, "options", void 0);
  }
  initialize(options) {
    if (this.isInitialized) {
      throw new Error('AlertingAuthorizationClientFactory already initialized');
    }
    this.isInitialized = true;
    this.options = options;
  }
  async create(request) {
    var _this$options$securit;
    this.validateInitialization();
    return _alerting_authorization.AlertingAuthorization.create({
      authorization: (_this$options$securit = this.options.securityPluginStart) === null || _this$options$securit === void 0 ? void 0 : _this$options$securit.authz,
      request,
      getSpace: this.options.getSpace,
      getSpaceId: this.options.getSpaceId,
      ruleTypeRegistry: this.options.ruleTypeRegistry,
      features: this.options.features
    });
  }
  validateInitialization() {
    if (!this.isInitialized || this.options == null) {
      throw new Error('AlertingAuthorizationClientFactory must be initialized before calling create');
    }
  }
}
exports.AlertingAuthorizationClientFactory = AlertingAuthorizationClientFactory;