"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MaintenanceWindowsEditPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _use_navigation = require("../../hooks/use_navigation");
var i18n = _interopRequireWildcard(require("./translations"));
var _page_header = require("./components/page_header");
var _create_maintenance_windows_form = require("./components/create_maintenance_windows_form");
var _common = require("../../../common");
var _use_get_maintenance_window = require("../../hooks/use_get_maintenance_window");
var _center_justified_spinner = require("./components/center_justified_spinner");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MaintenanceWindowsEditPage = exports.default = exports.MaintenanceWindowsEditPage = /*#__PURE__*/_react.default.memo(() => {
  const {
    navigateToMaintenanceWindows
  } = (0, _use_navigation.useMaintenanceWindowsNavigation)();
  (0, _use_breadcrumbs.useBreadcrumbs)(_common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindowsEdit);
  const {
    maintenanceWindowId
  } = (0, _reactRouterDom.useParams)();
  const {
    maintenanceWindow,
    showMultipleSolutionsWarning,
    isLoading,
    isError
  } = (0, _use_get_maintenance_window.useGetMaintenanceWindow)(maintenanceWindowId);
  if (isError) {
    navigateToMaintenanceWindows();
  }
  if (!maintenanceWindow || isLoading) {
    return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, {
    showBackButton: true,
    title: i18n.EDIT_MAINTENANCE_WINDOW
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), showMultipleSolutionsWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "maintenanceWindowMultipleSolutionsWarning",
    title: i18n.SOLUTION_CONFIG_REMOVAL_WARNING_TITLE,
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.SOLUTION_CONFIG_REMOVAL_WARNING_SUBTITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_create_maintenance_windows_form.CreateMaintenanceWindowForm, {
    initialValue: maintenanceWindow,
    maintenanceWindowId: maintenanceWindowId,
    onCancel: navigateToMaintenanceWindows,
    onSuccess: navigateToMaintenanceWindows
  }));
});
MaintenanceWindowsEditPage.displayName = 'MaintenanceWindowsEditPage';
// eslint-disable-next-line import/no-default-export