"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMinimumTimeRange = useMinimumTimeRange;
var _react = require("react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _moment = _interopRequireDefault(require("moment"));
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _minimum_time_range = require("./minimum_time_range");
var _storage = require("../../../types/storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMinimumTimeRange() {
  const {
    http
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const abortController = (0, _react.useRef)(new AbortController());
  const getMinimumTimeRange = (0, _react.useCallback)(async (index, timeField, timeRange, minimumTimeRangeOption, queryIn, runtimeMappings, headers) => {
    const minimumTimeRange = _minimum_time_range.MINIMUM_TIME_RANGE[minimumTimeRangeOption];
    const minimumTimeRangeMs = _moment.default.duration(minimumTimeRange.factor, minimumTimeRange.unit).asMilliseconds();
    const currentMinimumTimeRange = timeRange.to - timeRange.from;

    // the time range is already wide enough
    if (currentMinimumTimeRange > minimumTimeRangeMs) {
      return {
        ...timeRange,
        useSubAgg: false
      };
    }
    const resp = await (0, _mlDatePicker.getTimeFieldRange)({
      http,
      index,
      timeFieldName: timeField,
      query: queryIn,
      runtimeMappings,
      path: '/internal/file_upload/time_field_range',
      signal: abortController.current.signal
    });
    if (resp.end.epoch === null || resp.start.epoch === null) {
      // epoch can be null if no data can be found.
      return {
        ...timeRange,
        useSubAgg: false
      };
    }

    // the index isn't big enough to get a wider time range
    const indexTimeRangeMs = resp.end.epoch - resp.start.epoch;
    if (indexTimeRangeMs < minimumTimeRangeMs) {
      return {
        from: resp.start.epoch,
        to: resp.end.epoch,
        useSubAgg: true
      };
    }
    const remainder = minimumTimeRangeMs - currentMinimumTimeRange;
    const newFrom = Math.max(timeRange.from - remainder, resp.start.epoch);
    const newTo = Math.min(newFrom + minimumTimeRangeMs, resp.end.epoch);
    return {
      from: newFrom,
      to: newTo,
      useSubAgg: true
    };
  }, [http]);
  const [minimumTimeRangeOption, setMinimumTimeRangeOption] = (0, _mlLocalStorage.useStorage)(_storage.AIOPS_PATTERN_ANALYSIS_MINIMUM_TIME_RANGE_PREFERENCE, _minimum_time_range.DEFAULT_MINIMUM_TIME_RANGE_OPTION);
  const cancelRequest = (0, _react.useCallback)(() => {
    abortController.current.abort();
    abortController.current = new AbortController();
  }, []);
  return {
    getMinimumTimeRange,
    cancelRequest,
    minimumTimeRangeOption,
    setMinimumTimeRangeOption
  };
}