"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableHeader = exports.OpenInDiscoverButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _get_category_query = require("@kbn/aiops-log-pattern-analysis/get_category_query");
var _use_eui_theme = require("../../../hooks/use_eui_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TableHeader = ({
  categoriesCount,
  selectedCategoriesCount,
  openInDiscover
}) => {
  const euiTheme = (0, _use_eui_theme.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    css: {
      minHeight: euiTheme.euiSizeXL
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "aiopsLogPatternsFoundCount"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.counts",
    defaultMessage: "{count} {count, plural, one {pattern} other {patterns}} found",
    values: {
      count: categoriesCount
    }
  }), selectedCategoriesCount > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.selectedCounts",
    defaultMessage: " | {count} selected",
    values: {
      count: selectedCategoriesCount
    }
  })) : null)), selectedCategoriesCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(OpenInDiscoverButtons, {
    openInDiscover: openInDiscover
  })) : null);
};
exports.TableHeader = TableHeader;
const OpenInDiscoverButtons = ({
  openInDiscover,
  showText = true
}) => {
  const {
    getLabels,
    openFunction
  } = openInDiscover;
  const labels = getLabels(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(TooltipWrapper, {
    text: labels.multiSelect.in,
    showText: showText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "aiopsLogPatternAnalysisOpenInDiscoverIncludeButton",
    size: "s",
    onClick: () => openFunction(_get_category_query.QUERY_MODE.INCLUDE, true),
    iconType: "plusInCircle",
    iconSide: "left"
  }, labels.multiSelect.in))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(TooltipWrapper, {
    text: labels.multiSelect.out,
    showText: showText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "aiopsLogPatternAnalysisOpenInDiscoverExcludeButton",
    size: "s",
    onClick: () => openFunction(_get_category_query.QUERY_MODE.EXCLUDE, true),
    iconType: "minusInCircle",
    iconSide: "left"
  }, labels.multiSelect.out))));
};
exports.OpenInDiscoverButtons = OpenInDiscoverButtons;
const TooltipWrapper = ({
  text,
  showText,
  children
}) => {
  return showText ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: text
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children));
};