"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttachmentsMenu = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/presentation-util-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("@kbn/aiops-log-pattern-analysis/constants");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _use_cases_modal = require("../../hooks/use_cases_modal");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _constants2 = require("../../cases/constants");
var _get_dataview_references = require("../../embeddables/get_dataview_references");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SavedObjectSaveModalDashboard = (0, _public.withSuspense)(_public.LazySavedObjectSaveModalDashboard);
const AttachmentsMenu = ({
  randomSamplerMode,
  randomSamplerProbability,
  dataView,
  selectedField
}) => {
  var _cases$helpers$canUse, _cases$helpers, _panels$, _panels$$items;
  const {
    application: {
      capabilities
    },
    cases,
    embeddable
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const [applyTimeRange, setApplyTimeRange] = (0, _react.useState)(false);
  const [dashboardAttachmentReady, setDashboardAttachmentReady] = (0, _react.useState)(false);
  const [isActionMenuOpen, setIsActionMenuOpen] = (0, _react.useState)(false);
  const {
    create: canCreateCase,
    update: canUpdateCase
  } = (_cases$helpers$canUse = cases === null || cases === void 0 ? void 0 : (_cases$helpers = cases.helpers) === null || _cases$helpers === void 0 ? void 0 : _cases$helpers.canUseCases()) !== null && _cases$helpers$canUse !== void 0 ? _cases$helpers$canUse : {
    create: false,
    update: false
  };
  const openCasesModalCallback = (0, _use_cases_modal.useCasesModal)(_constants.EMBEDDABLE_PATTERN_ANALYSIS_TYPE, _constants2.CASES_TOAST_MESSAGES_TITLES.PATTERN_ANALYSIS);
  const timeRange = (0, _mlDatePicker.useTimeRangeUpdates)();
  const canEditDashboards = capabilities.dashboard.createNew;
  const onSave = (0, _react.useCallback)(async ({
    dashboardId,
    newTitle,
    newDescription
  }) => {
    const stateTransfer = embeddable.getStateTransfer();
    const embeddableInput = {
      title: newTitle,
      description: newDescription,
      dataViewId: dataView.id,
      fieldName: selectedField,
      randomSamplerMode,
      randomSamplerProbability,
      minimumTimeRangeOption: 'No minimum',
      ...(applyTimeRange && {
        timeRange
      })
    };
    const state = {
      serializedState: {
        rawState: embeddableInput,
        references: (0, _get_dataview_references.getDataviewReferences)(dataView.id, _constants.PATTERN_ANALYSIS_DATA_VIEW_REF_NAME)
      },
      type: _constants.EMBEDDABLE_PATTERN_ANALYSIS_TYPE
    };
    const path = dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`;
    stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
      state,
      path
    });
  }, [embeddable, dataView.id, selectedField, randomSamplerMode, randomSamplerProbability, applyTimeRange, timeRange]);
  const panels = (0, _react.useMemo)(() => {
    return [{
      id: 'attachMainPanel',
      size: 's',
      items: [...(canEditDashboards ? [{
        name: _i18n.i18n.translate('xpack.aiops.logCategorization.addToDashboardTitle', {
          defaultMessage: 'Add to dashboard'
        }),
        panel: 'attachToDashboardPanel',
        icon: 'dashboardApp',
        'data-test-subj': 'aiopsLogPatternAnalysisAttachToDashboardButton'
      }] : []), ...(canUpdateCase || canCreateCase ? [{
        name: _i18n.i18n.translate('xpack.aiops.logCategorization.attachToCaseLabel', {
          defaultMessage: 'Add to case'
        }),
        icon: 'casesApp',
        'data-test-subj': 'aiopsLogPatternAnalysisAttachToCaseButton',
        onClick: () => {
          setIsActionMenuOpen(false);
          openCasesModalCallback({
            dataViewId: dataView.id,
            fieldName: selectedField,
            minimumTimeRangeOption: 'No minimum',
            randomSamplerMode,
            randomSamplerProbability,
            timeRange
          });
        }
      }] : [])]
    }, {
      id: 'attachToDashboardPanel',
      size: 's',
      title: _i18n.i18n.translate('xpack.aiops.logCategorization.addToDashboardTitle', {
        defaultMessage: 'Add to dashboard'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        paddingSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: _i18n.i18n.translate('xpack.aiops.logCategorization.applyTimeRangeLabel', {
          defaultMessage: 'Apply time range'
        }),
        checked: applyTimeRange,
        onChange: e => setApplyTimeRange(e.target.checked)
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        "data-test-subj": "aiopsLogPatternAnalysisAttachToDashboardSubmitButton",
        fill: true,
        fullWidth: true,
        type: 'submit',
        onClick: () => {
          setIsActionMenuOpen(false);
          setDashboardAttachmentReady(true);
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logCategorization.attachToDashboardSubmitButtonLabel",
        defaultMessage: "Attach"
      }))))
    }];
  }, [canEditDashboards, canUpdateCase, canCreateCase, applyTimeRange, openCasesModalCallback, dataView.id, selectedField, randomSamplerMode, randomSamplerProbability, timeRange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!((_panels$ = panels[0]) !== null && _panels$ !== void 0 && (_panels$$items = _panels$.items) !== null && _panels$$items !== void 0 && _panels$$items.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "aiopsLogPatternAnalysisAttachmentsMenuButton",
      "aria-label": _i18n.i18n.translate('xpack.aiops.logCategorization.attachmentsMenuAriaLabel', {
        defaultMessage: 'Attachments'
      }),
      size: "m",
      color: "text",
      display: "base",
      isSelected: isActionMenuOpen,
      iconType: "boxesHorizontal",
      onClick: () => setIsActionMenuOpen(!isActionMenuOpen)
    }),
    isOpen: isActionMenuOpen,
    closePopover: () => setIsActionMenuOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    panels: panels,
    initialPanelId: "attachMainPanel"
  }))), dashboardAttachmentReady ? /*#__PURE__*/_react.default.createElement(SavedObjectSaveModalDashboard, {
    canSaveByReference: false,
    objectType: _i18n.i18n.translate('xpack.aiops.logCategorization.objectTypeLabel', {
      defaultMessage: 'Log pattern analysis'
    }),
    documentInfo: {
      title: 'Log pattern analysis'
    },
    onClose: () => setDashboardAttachmentReady(false),
    onSave: onSave
  }) : null);
};
exports.AttachmentsMenu = AttachmentsMenu;