"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERTICAL_ALIGN = exports.EuiTimelineItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _timeline_item_event = require("./timeline_item_event");
var _timeline_item_icon = require("./timeline_item_icon");
var _timeline_item = require("./timeline_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "verticalAlign", "icon", "iconAriaLabel"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var VERTICAL_ALIGN = exports.VERTICAL_ALIGN = ['top', 'center'];
var EuiTimelineItem = exports.EuiTimelineItem = function EuiTimelineItem(_ref) {
  var children = _ref.children,
    _ref$verticalAlign = _ref.verticalAlign,
    verticalAlign = _ref$verticalAlign === void 0 ? 'center' : _ref$verticalAlign,
    icon = _ref.icon,
    iconAriaLabel = _ref.iconAriaLabel,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _timeline_item.euiTimelineItemStyles)();
  var cssStyles = [styles.euiTimelineItem, styles[verticalAlign]];
  return (0, _react2.jsx)("li", _extends({
    css: cssStyles
  }, rest), (0, _react2.jsx)(_timeline_item_icon.EuiTimelineItemIcon, {
    icon: icon,
    iconAriaLabel: iconAriaLabel,
    verticalAlign: verticalAlign
  }), (0, _react2.jsx)(_timeline_item_event.EuiTimelineItemEvent, {
    verticalAlign: verticalAlign
  }, children));
};
EuiTimelineItem.propTypes = {
  /**
     * Vertical alignment of the event with the icon
     */
  verticalAlign: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};