"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFilePickerClass = exports.EuiFilePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _button = require("../../button");
var _progress = require("../../progress");
var _icon = require("../../icon");
var _i18n = require("../../i18n");
var _loading = require("../../loading");
var _eui_form_context = require("../eui_form_context");
var _validatable_control = require("../validatable_control");
var _form_control_layout_clear_button = require("../form_control_layout/form_control_layout_clear_button");
var _file_picker = require("./file_picker.styles");
var _react2 = require("@emotion/react");
var _excluded = ["stylesMemoizer", "id", "name", "initialPromptText", "className", "disabled", "compressed", "onChange", "isInvalid", "fullWidth", "isLoading", "display"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiFilePickerClass = exports.EuiFilePickerClass = /*#__PURE__*/function (_Component) {
  function EuiFilePickerClass() {
    var _this;
    _classCallCheck(this, EuiFilePickerClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFilePickerClass, [].concat(args));
    _defineProperty(_this, "state", {
      promptText: null,
      isHoveringDrop: false
    });
    _defineProperty(_this, "fileInput", null);
    _defineProperty(_this, "generatedId", (0, _services.htmlIdGenerator)()());
    _defineProperty(_this, "handleChange", function () {
      if (!_this.fileInput) return;
      if (_this.fileInput.files && _this.fileInput.files.length > 1) {
        _this.setState({
          promptText: (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiFilePicker.filesSelected",
            default: "{fileCount} files selected",
            values: {
              fileCount: _this.fileInput.files.length
            }
          })
        });
      } else if (_this.fileInput.files && _this.fileInput.files.length === 0) {
        _this.setState({
          promptText: null
        });
      } else {
        _this.setState({
          promptText: _this.fileInput.value.split('\\').pop()
        });
      }
      var onChange = _this.props.onChange;
      if (onChange) {
        onChange(_this.fileInput.files);
      }
    });
    _defineProperty(_this, "removeFiles", function (e) {
      if (e) {
        e.stopPropagation();
        e.preventDefault();
      }
      if (!_this.fileInput) return;
      _this.fileInput.value = '';
      _this.handleChange();
    });
    _defineProperty(_this, "showDrop", function () {
      if (!_this.props.disabled) {
        _this.setState({
          isHoveringDrop: true
        });
      }
    });
    _defineProperty(_this, "hideDrop", function () {
      _this.setState({
        isHoveringDrop: false
      });
    });
    return _this;
  }
  _inherits(EuiFilePickerClass, _Component);
  return _createClass(EuiFilePickerClass, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _ref = this.context,
        defaultFullWidth = _ref.defaultFullWidth;
      return (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiFilePicker.removeSelectedAriaLabel",
        default: "Remove selected files"
      }, function (removeSelectedAriaLabel) {
        var _this2$props = _this2.props,
          stylesMemoizer = _this2$props.stylesMemoizer,
          id = _this2$props.id,
          name = _this2$props.name,
          initialPromptText = _this2$props.initialPromptText,
          className = _this2$props.className,
          disabled = _this2$props.disabled,
          compressed = _this2$props.compressed,
          onChange = _this2$props.onChange,
          isInvalid = _this2$props.isInvalid,
          _this2$props$fullWidt = _this2$props.fullWidth,
          fullWidth = _this2$props$fullWidt === void 0 ? defaultFullWidth : _this2$props$fullWidt,
          isLoading = _this2$props.isLoading,
          display = _this2$props.display,
          rest = _objectWithoutProperties(_this2$props, _excluded);
        var promptId = "".concat(id || _this2.generatedId, "-filePicker__prompt");
        var isOverridingInitialPrompt = _this2.state.promptText != null;
        var normalFormControl = display === 'default';
        var classes = (0, _classnames.default)('euiFilePicker', {
          'euiFilePicker-isDroppingFile': _this2.state.isHoveringDrop,
          'euiFilePicker-isInvalid': isInvalid,
          'euiFilePicker-isLoading': isLoading,
          'euiFilePicker-hasFiles': isOverridingInitialPrompt
        }, className);
        var styles = stylesMemoizer(_file_picker.euiFilePickerStyles);
        var cssStyles = [styles.euiFilePicker, fullWidth ? styles.fullWidth : styles.formWidth, _this2.state.isHoveringDrop && styles.isDroppingFile, isInvalid && !disabled && styles.invalid, isOverridingInitialPrompt && !disabled && styles.hasFiles, isLoading && styles.loading];
        var inputStyles = [styles.input.euiFilePicker__input, !normalFormControl && !disabled && styles.input.largeInteractive];
        var promptStyles = [styles.euiFilePicker__prompt, disabled && styles.disabled].concat(_toConsumableArray(normalFormControl ? [compressed ? styles.compressed : styles.uncompressed] : [styles.large.large, compressed ? styles.large.compressed : styles.large.uncompressed]));
        var iconStyles = [styles.icon.euiFilePicker__icon].concat(_toConsumableArray(normalFormControl ? [styles.icon.normal, compressed ? styles.icon.compresssed : styles.icon.uncompressed] : [styles.icon.large]));
        var rightIconStyles = normalFormControl ? [styles.rightIcon.euiFilePicker__rightIcon, compressed ? styles.rightIcon.compressed : styles.rightIcon.uncompressed] : undefined;
        var clearButton;
        if (isLoading && normalFormControl) {
          // Override clear button with loading spinner if it is in loading state
          clearButton = (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
            css: rightIconStyles,
            className: "euiFilePicker__loadingSpinner",
            size: compressed ? 's' : 'm'
          });
        } else if (isOverridingInitialPrompt && !disabled) {
          if (normalFormControl) {
            clearButton = (0, _react2.jsx)(_form_control_layout_clear_button.EuiFormControlLayoutClearButton, {
              "aria-label": removeSelectedAriaLabel,
              css: [styles.euiFilePicker__clearButton, rightIconStyles, ";label:clearButton;"],
              className: "euiFilePicker__clearButton",
              onClick: _this2.removeFiles,
              size: compressed ? 's' : 'm'
            });
          } else {
            clearButton = (0, _react2.jsx)(_button.EuiButtonEmpty, {
              "aria-label": removeSelectedAriaLabel,
              css: styles.euiFilePicker__clearButton,
              className: "euiFilePicker__clearButton",
              size: "xs",
              onClick: _this2.removeFiles
            }, (0, _react2.jsx)(_i18n.EuiI18n, {
              token: "euiFilePicker.removeSelected",
              default: "Remove"
            }));
          }
        } else {
          clearButton = null;
        }
        var loader = !normalFormControl && isLoading && (0, _react2.jsx)(_progress.EuiProgress, {
          size: "xs",
          color: "accent",
          position: "absolute"
        });
        return (0, _react2.jsx)("div", {
          css: cssStyles,
          className: classes
        }, (0, _react2.jsx)(_validatable_control.EuiValidatableControl, {
          isInvalid: isInvalid
        }, (0, _react2.jsx)("input", _extends({
          type: "file",
          id: id,
          name: name,
          css: inputStyles,
          className: "euiFilePicker__input",
          onChange: _this2.handleChange,
          ref: function ref(input) {
            _this2.fileInput = input;
          },
          onDragOver: _this2.showDrop,
          onDragLeave: _this2.hideDrop,
          onDrop: _this2.hideDrop,
          disabled: disabled,
          "aria-describedby": promptId
        }, rest))), (0, _react2.jsx)("div", {
          css: promptStyles,
          className: "euiFilePicker__prompt",
          id: promptId
        }, (0, _react2.jsx)(_icon.EuiIcon, {
          css: iconStyles,
          className: "euiFilePicker__icon",
          color: isInvalid ? 'danger' : disabled ? 'subdued' : 'primary',
          type: isInvalid ? 'alert' : 'importAction',
          size: normalFormControl ? 'm' : 'l',
          "aria-hidden": "true"
        }), (0, _react2.jsx)("span", {
          className: "euiFilePicker__promptText"
        }, _this2.state.promptText || initialPromptText), clearButton, loader));
      });
    }
  }]);
}(_react.Component);
_defineProperty(EuiFilePickerClass, "contextType", _eui_form_context.FormContext);
_defineProperty(EuiFilePickerClass, "defaultProps", {
  initialPromptText: (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiFilePicker.promptText",
    default: "Select or drag and drop a file"
  }),
  compressed: false,
  display: 'large'
});
EuiFilePickerClass.propTypes = {
  id: _propTypes.default.string,
  name: _propTypes.default.string,
  className: _propTypes.default.string,
  /**
     * The content that appears in the dropzone if no file is attached
     * @default 'Select or drag and drop a file'
     */
  initialPromptText: _propTypes.default.node,
  /**
     * Use as a callback to access the HTML FileList API
     */
  onChange: _propTypes.default.func,
  /**
     * Reduces the size to a typical (compressed) input
     * @default false
     */
  compressed: _propTypes.default.bool,
  /**
     * Size or type of display;
     * `default` for normal height, similar to other controls;
     * `large` for taller size
     * @default large
     */
  display: _propTypes.default.oneOf(["default", "large"]),
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: _propTypes.default.bool,
  isInvalid: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};
var EuiFilePicker = exports.EuiFilePicker = (0, _services.withEuiStylesMemoizer)(EuiFilePickerClass);