"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getInternalIsInitializedSelector = exports.InitStatus = void 0;
const get_internal_chart_state_1 = require("./get_internal_chart_state");
exports.InitStatus = Object.freeze({
    ParentSizeInvalid: 'ParentSizeInvalid',
    SpecNotInitialized: 'SpecNotInitialized',
    MissingChartType: 'MissingChartType',
    ChartNotInitialized: 'ChartNotInitialized',
    Initialized: 'Initialized',
});
const getInternalIsInitializedSelector = (globalChartState) => {
    const { parentDimensions: { width, height }, specsInitialized, } = globalChartState;
    if (!specsInitialized) {
        return exports.InitStatus.SpecNotInitialized;
    }
    const internalChartState = (0, get_internal_chart_state_1.getInternalChartStateSelector)(globalChartState);
    if (!internalChartState) {
        return exports.InitStatus.MissingChartType;
    }
    if (width <= 0 || height <= 0) {
        return exports.InitStatus.ParentSizeInvalid;
    }
    return internalChartState.isInitialized(globalChartState);
};
exports.getInternalIsInitializedSelector = getInternalIsInitializedSelector;
//# sourceMappingURL=get_internal_is_intialized.js.map