"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartStatus = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const create_selector_1 = require("../state/create_selector");
const get_internal_chart_state_1 = require("../state/selectors/get_internal_chart_state");
const get_settings_spec_1 = require("../state/selectors/get_settings_spec");
class ChartStatusComponent extends react_1.default.Component {
    componentDidMount() {
        this.dispatchRenderChange();
    }
    componentDidUpdate() {
        this.dispatchRenderChange();
    }
    componentWillUnmount() {
        create_selector_1.globalSelectorCache.removeKeyFromAll(this.props.chartId);
    }
    dispatchRenderChange = () => {
        const { onWillRender, onRenderChange, rendered } = this.props;
        onWillRender?.();
        if (onRenderChange) {
            window.requestAnimationFrame(() => {
                onRenderChange(rendered);
            });
        }
    };
    render() {
        const { rendered, renderedCount, debugState } = this.props;
        const debugStateString = debugState && JSON.stringify(debugState);
        return (react_1.default.createElement("div", { className: "echChartStatus", "data-ech-render-complete": rendered, "data-ech-render-count": renderedCount, "data-ech-debug-state": debugStateString }));
    }
}
const mapStateToProps = (state) => {
    const internalChartState = (0, get_internal_chart_state_1.getInternalChartStateSelector)(state);
    const { onWillRender, onRenderChange, debugState } = (0, get_settings_spec_1.getSettingsSpecSelector)(state);
    return {
        chartId: state.chartId,
        rendered: state.chartRendered,
        renderedCount: state.chartRenderedCount,
        onWillRender,
        onRenderChange,
        debugState: debugState && internalChartState ? internalChartState.getDebugState(state) : null,
    };
};
exports.ChartStatus = (0, react_redux_1.connect)(mapStateToProps)(ChartStatusComponent);
//# sourceMappingURL=chart_status.js.map