"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.chartSelectorsFactory = void 0;
const can_display_chart_titles_1 = require("./selectors/can_display_chart_titles");
const get_debug_state_1 = require("./selectors/get_debug_state");
const get_tooltip_anchor_1 = require("./selectors/get_tooltip_anchor");
const get_tooltip_info_1 = require("./selectors/get_tooltip_info");
const is_tooltip_visible_1 = require("./selectors/is_tooltip_visible");
const chart_selectors_1 = require("../../state/chart_selectors");
const get_internal_is_intialized_1 = require("../../state/selectors/get_internal_is_intialized");
exports.chartSelectorsFactory = (0, chart_selectors_1.createChartSelectorsFactory)({
    getChartTypeDescription: () => 'Bullet chart',
    isInitialized: () => get_internal_is_intialized_1.InitStatus.Initialized,
    isChartEmpty: () => false,
    isTooltipVisible: is_tooltip_visible_1.isTooltipVisible,
    getTooltipInfo: get_tooltip_info_1.getTooltipInfo,
    getTooltipAnchor: get_tooltip_anchor_1.getTooltipAnchor,
    getDebugState: (state) => (0, get_debug_state_1.getDebugStateSelector)(state),
    canDisplayChartTitles: can_display_chart_titles_1.canDisplayChartTitles,
});
//# sourceMappingURL=chart_selectors.js.map