"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.basicLogger = exports.init = void 0;
/**
 * This is the API reference for the LaunchDarkly Server-Side SDK for Node.js.
 *
 * In typical usage, you will call {@link init} once at startup time to obtain an instance of
 * {@link LDClient}, which provides access to all of the SDK's functionality.
 *
 * For more information, see the SDK reference guide.
 *
 * @packageDocumentation
 */
const js_server_sdk_common_1 = require("@launchdarkly/js-server-sdk-common");
const LDClientNode_1 = require("./LDClientNode");
__exportStar(require("@launchdarkly/js-server-sdk-common"), exports);
/**
 * Creates an instance of the LaunchDarkly client.
 *
 * Applications should instantiate a single instance for the lifetime of the application.
 * The client will begin attempting to connect to LaunchDarkly as soon as it is created. To
 * determine when it is ready to use, call {@link LDClient.waitForInitialization}, or register an
 * event listener for the `"ready"` event using {@link LDClient.on}.
 *
 * **Important:** Do **not** try to instantiate `LDClient` with its constructor
 * (`new LDClient()/new LDClientImpl()/new LDClientNode()`); the SDK does not currently support
 * this.
 *
 * @param key
 *   The SDK key.
 * @param options
 *   Optional configuration settings.
 * @return
 *   The new {@link LDClient} instance.
 */
function init(sdkKey, options = {}) {
    return new LDClientNode_1.default(sdkKey, options);
}
exports.init = init;
/**
 * Provides a simple {@link LDLogger} implementation.
 *
 * This logging implementation uses a simple format that includes only the log level
 * and the message text. Output is written to the standard error stream (`console.error`).
 * You can filter by log level as described in [[BasicLoggerOptions.level]].
 *
 * To use the logger created by this function, put it into {@link LDOptions.logger}. If
 * you do not set {@link LDOptions.logger} to anything, the SDK uses a default logger
 * that is equivalent to `basicLogger({ level: 'info' })`.
 *
 * @param options Configuration for the logger. If no options are specified, the
 *   logger uses `{ level: 'info' }`.
 *
 * @example
 * This example shows how to use `basicLogger` in your SDK options to enable console
 * logging only at `warn` and `error` levels.
 * ```javascript
 *   const ldOptions = {
 *     logger: basicLogger({ level: 'warn' }),
 *   };
 * ```
 *
 * @example
 * This example shows how to use `basicLogger` in your SDK options to cause log
 * output to go to `console.log` instead of `console.error`.
 * ```javascript
 *   const ldOptions = {
 *     logger: ld.basicLogger({ destination: console.log }),
 *   };
 * ```
 */
function basicLogger(options) {
    return new js_server_sdk_common_1.BasicLogger(options);
}
exports.basicLogger = basicLogger;
//# sourceMappingURL=index.js.map