"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// eslint-disable-next-line max-classes-per-file
const events_1 = require("events");
const util_1 = require("util");
const js_server_sdk_common_1 = require("@launchdarkly/js-server-sdk-common");
const BigSegmentsStoreStatusProviderNode_1 = require("./BigSegmentsStoreStatusProviderNode");
const NodePlatform_1 = require("./platform/NodePlatform");
/**
 * @ignore
 */
class LDClientNode extends js_server_sdk_common_1.LDClientImpl {
    constructor(sdkKey, options) {
        const fallbackLogger = new js_server_sdk_common_1.BasicLogger({
            level: 'info',
            // eslint-disable-next-line no-console
            destination: console.error,
            formatter: util_1.format,
        });
        const logger = options.logger ? new js_server_sdk_common_1.SafeLogger(options.logger, fallbackLogger) : fallbackLogger;
        const emitter = new events_1.EventEmitter();
        const pluginValidator = js_server_sdk_common_1.TypeValidators.createTypeArray('LDPlugin', {});
        const plugins = [];
        if (options.plugins) {
            if (pluginValidator.is(options.plugins)) {
                plugins.push(...options.plugins);
            }
            else {
                logger.warn('Could not validate plugins.');
            }
        }
        const baseOptions = Object.assign(Object.assign({}, options), { logger });
        delete baseOptions.plugins;
        super(sdkKey, new NodePlatform_1.default(Object.assign(Object.assign({}, options), { logger })), baseOptions, {
            onError: (err) => {
                if (emitter.listenerCount('error')) {
                    emitter.emit('error', err);
                }
                else {
                    logger.error(err.message);
                }
            },
            onFailed: (err) => {
                emitter.emit('failed', err);
            },
            onReady: () => {
                emitter.emit('ready');
            },
            onUpdate: (key) => {
                emitter.emit('update', { key });
                emitter.emit(`update:${key}`, { key });
            },
            hasEventListeners: () => emitter
                .eventNames()
                .some((name) => name === 'update' || (typeof name === 'string' && name.startsWith('update:'))),
        }, {
            getImplementationHooks: (environmentMetadata) => js_server_sdk_common_1.internal.safeGetHooks(logger, environmentMetadata, plugins),
        });
        this.emitter = emitter;
        this.bigSegmentStoreStatusProvider = new BigSegmentsStoreStatusProviderNode_1.default(this.bigSegmentStatusProviderInternal);
        js_server_sdk_common_1.internal.safeRegisterPlugins(logger, this.environmentMetadata, this, plugins);
    }
    // #region: EventEmitter
    on(eventName, listener) {
        this.emitter.on(eventName, listener);
        return this;
    }
    addListener(eventName, listener) {
        this.emitter.addListener(eventName, listener);
        return this;
    }
    once(eventName, listener) {
        this.emitter.once(eventName, listener);
        return this;
    }
    removeListener(eventName, listener) {
        this.emitter.removeListener(eventName, listener);
        return this;
    }
    off(eventName, listener) {
        this.emitter.off(eventName, listener);
        return this;
    }
    removeAllListeners(event) {
        this.emitter.removeAllListeners(event);
        return this;
    }
    setMaxListeners(n) {
        this.emitter.setMaxListeners(n);
        return this;
    }
    getMaxListeners() {
        return this.emitter.getMaxListeners();
    }
    listeners(eventName) {
        return this.emitter.listeners(eventName);
    }
    rawListeners(eventName) {
        return this.emitter.rawListeners(eventName);
    }
    emit(eventName, ...args) {
        return this.emitter.emit(eventName, args);
    }
    listenerCount(eventName) {
        return this.emitter.listenerCount(eventName);
    }
    prependListener(eventName, listener) {
        this.emitter.prependListener(eventName, listener);
        return this;
    }
    prependOnceListener(eventName, listener) {
        this.emitter.prependOnceListener(eventName, listener);
        return this;
    }
    eventNames() {
        return this.emitter.eventNames();
    }
}
exports.default = LDClientNode;
//# sourceMappingURL=LDClientNode.js.map