"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class UpdateQueue {
    constructor() {
        this._queue = [];
    }
    enqueue(updateFn, cb) {
        this._queue.push([updateFn, cb]);
        if (this._queue.length === 1) {
            // If this is the only item in the queue, then there is not a series
            // of updates already in progress. So we can start executing those updates.
            this.executePendingUpdates();
        }
    }
    executePendingUpdates() {
        if (this._queue.length > 0) {
            const [fn, cb] = this._queue[0];
            const newCb = () => {
                // We just completed work, so remove it from the queue.
                // Don't remove it before the work is done, because then the
                // count could hit 0, and overlapping execution chains could be started.
                this._queue.shift();
                // There is more work to do, so schedule an update.
                if (this._queue.length > 0) {
                    setTimeout(() => this.executePendingUpdates(), 0);
                }
                // Call the original callback.
                cb === null || cb === void 0 ? void 0 : cb();
            };
            fn(newCb);
        }
    }
}
exports.default = UpdateQueue;
//# sourceMappingURL=UpdateQueue.js.map