"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBucketBy = exports.getOffVariation = exports.getVariation = void 0;
const js_sdk_common_1 = require("@launchdarkly/js-sdk-common");
const EvalResult_1 = require("./EvalResult");
const { ErrorKinds } = js_sdk_common_1.internal;
const KEY_ATTR_REF = new js_sdk_common_1.AttributeReference('key');
/**
 * Attempt to get an evaluation result for the specific variation/flag combination.
 * @param flag The flag to get a variation from.
 * @param index The index of the flag.
 * @param reason The initial evaluation reason. If there is a valid variation, then this reason
 * will be returned in the EvalResult.
 * @returns An evaluation result containing the successful evaluation, or an error if there is
 * a problem accessing the variation.
 *
 * @internal
 */
function getVariation(flag, index, reason) {
    if (js_sdk_common_1.TypeValidators.Number.is(index) && index >= 0 && index < flag.variations.length) {
        return EvalResult_1.default.forSuccess(flag.variations[index], reason, index);
    }
    return EvalResult_1.default.forError(ErrorKinds.MalformedFlag, 'Invalid variation index in flag');
}
exports.getVariation = getVariation;
/**
 * Attempt to get an off result for the specified flag.
 * @param flag The flag to get the off variation for.
 * @param reason The initial reason for the evaluation result.
 * @returns A successful evaluation result, or an error result if there is a problem accessing
 * the off variation. Flags which do not have an off variation specified will get a `null` flag
 * value with an `undefined` variation.
 *
 * @internal
 */
function getOffVariation(flag, reason) {
    if (!js_sdk_common_1.TypeValidators.Number.is(flag.offVariation)) {
        return EvalResult_1.default.forSuccess(null, reason);
    }
    return getVariation(flag, flag.offVariation, reason);
}
exports.getOffVariation = getOffVariation;
function getBucketBy(isExperiment, bucketByAttributeReference) {
    var _a;
    return (_a = (isExperiment ? undefined : bucketByAttributeReference)) !== null && _a !== void 0 ? _a : KEY_ATTR_REF;
}
exports.getBucketBy = getBucketBy;
//# sourceMappingURL=variations.js.map